# rubiks-cube-solver-haskell
A parallelized Rubik’s Cube solver implemented in Haskell.



System Requirments: 

Make sure you have both stack and ghc installed on your system.



### Cube Representation and Move Functions

* **Implementation**: `RubikCube.hs`.

* **Tests**: `TestRubikCube.hs`.



#### How to run test:

* In GHCi:
  ~~~
  stack ghci
  ghci> :load TestRubikCube.hs
  ghci> main
  ~~~

* or compile it:
  ~~~
  stack ghc -- -O2 TestRubikCube.hs
  ./TestRubikCube
  ~~~

Expected output:
~~~
...
Test Passed: moveF and moveFi are inverses.
...
Test Passed: moveR and moveRi are inverses.
...
Test Passed: Cube restored to solved state.
~~~






### Pattern Database Construction

* **Implementation**: `PDB.hs` and `GeneratePDB.hs`.



#### How to generate PDB:

* In GHCi:
  You may need to increase the stack size if a stack over flow exeception occurs in later steps.

  ~~~
  stack ghci --ghci-options "+RTS -K1G"
  ghci> :load GeneratePDB.hs
  :main <filePath> <n> <depthLimit>
  ~~~

  `<filePath>` specifies the output file path. 

  `<n>` is the cube size and can only be 2 or 3 for now.

  `depthLimit` specifies how far you want to go from the solved cube. The larger it is, the larger the pattern database and the longer it takes to construct.

  If you want to generate the pattern database for a 3x3 cube with a depth limit of 6 and save it to a file `pdb_3x3_6.dat`, you can do the following:

  ~~~
  :main pdb_3x3_6.dat 3 6
  ~~~

  Similarly, you can generate the pattern database for a 2x2 cube with a depth limit of 6 and save it to a file `pdb_2x2_6.dat`

  ~~~
  :main pdb_2x2_6.dat 2 6
  ~~~

* or compile it:
  ~~~
  stack ghc -- -O2 GeneratePDB.hs
  ./GeneratePDB <filePath> <n> <depthLimit>
  ~~~

Expected output.

~~~
./GeneratePDB pdb_3x3_6.dat 3 6
Generating PDB with cube size 3 and depth limit 6
PDB saved to pdb_3x3_6.dat
Loading PDB from pdb_3x3_6.dat
PDB contains 983926 entries.
Some entries in the PDB (key as list of Word8 and depth):
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5], Depth: 0
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,2,2,2,4,4,4,4,4,4,5,5,5,5,5,5,5,5,5,4,4,4], Depth: 2
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,4,4,4,3,3,3,3,3,3,5,5,5,4,4,4,4,4,4,3,3,3,5,5,5,5,5,5,2,2,2], Depth: 1
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,5,5,5,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,2,2,2,5,5,5,5,5,5,3,3,3], Depth: 1
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,2,2,3,2,2,3,3,3,2,3,3,2,3,3,2,5,4,4,5,4,4,5,5,4,4,5,5,4,5,5,4,4,5], Depth: 6
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,2,2,3,2,2,3,3,3,2,3,3,2,3,3,2,5,5,4,5,4,4,5,4,4,4,4,5,4,5,5,4,5,5], Depth: 6
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,3,2,2,3,2,3,3,3,3,2,3,3,2,3,2,2,5,4,4,5,4,4,5,4,4,4,5,5,4,5,5,4,5,5], Depth: 6
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,3,3,2,2,3,2,2,3,3,2,2,3,3,2,3,3,2,5,4,4,5,4,4,5,4,4,4,5,5,4,5,5,4,5,5], Depth: 6
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,2,2,3,2,2,3,2,2,2,3,3,2,3,3,2,3,3,4,4,5,4,4,5,4,5,5,5,5,4,5,5,4,5,4,4], Depth: 6
Key: [0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,2,2,3,2,2,3,2,2,2,3,3,2,3,3,2,3,3,4,5,5,4,4,5,4,4,5,5,4,4,5,5,4,5,5,4], Depth: 6
~~~





### IDA* Seach Algorithm

Core logic: `IDAStar.hs`.

Solving cubes sequentially: `IDAStarLinear.hs`

Solving cubes in batch in parallel (each cube will be solved sequentially by a thread): `IDAStarBatch.hs`

Solving cubes in parallel (each cube will be solved in parallel, doesn't provide better performance though): `IDAStarPara.hs`

#### How to solve cubes:

1. Prepare the input file. Each line of an input file should be a list of moves to scramble the solved cube, separated by a comma and a space. Below are two examples.

   File `scramble_3x3.txt` contains two scrambled cubes. The first is obtained by performing the moves U, R, F, B, L, D on a solved cube, and the second by performing the moves Ui, Ri, Fi, Bi, Li, Di on a solved cube.

   ```
   U, R, F, B, L, D
   Ui, Ri, Fi, Bi, Li, Di
   ```

   File `scramble_2x2.txt` contains one cube scrambled with 30 moves.

   ~~~
   U, R, F, B, L, D, Ui, Ri, Fi, Bi, Li, Di, U, R, F, B, L, D, Ui, Ri, Fi, Bi, Li, Di, U, R, F, B, L, D
   ~~~

2. Choose one algorithm to use, `IDAStarLinear.hs`, `IDAStarBatch.hs` or  `IDAStarPara.hs`

3. Compile and run. 
   ~~~
   stack ghc -- -O IDAStarLinear.hs
   ./IDAStarLinear <pdb_file> <n> <scramble_file> [log_level]
   ~~~

   ~~~
   stack ghc -- -O -rtsopts -threaded IDAStarBatch.hs
   ./IDAStarBatch <pdb_file> <n> <scramble_file> +RTS -N1 -ls -RTS
   ~~~

   ~~~
   stack ghc -- -O IDAStarPara.hs
   ./IDAStarPara <pdb_file> <n> <scramble_file> [log_level]
   ~~~

   `<pdb_file>` is the pattern database file you generated from `GeneratePDB.hs`.

   `<n>` is the cube size and can only be 2 or 3 for now.

   `<scramble_file>` is your input file, each line representing a scrambled cube.

   `[log_level]` can be DEBUG, INFO, ERROR.

   Examples:
   ~~~
   ./IDAStarLinear pdb_2x2_6.dat 2 scramble_2x2.txt DEBUG
   
   Solving cube #1
   Scrambled Cube:
   Up Face:
   "OR"
   "GW"
   Front Face:
   "WB"
   "OB"
   Right Face:
   "OB"
   "OY"
   Back Face:
   "WG"
   "GY"
   Left Face:
   "WR"
   "RY"
   Down Face:
   "GY"
   "BR"
   Starting IDA* search...
   After applying solution moves, cube state:
   Up Face:
   "WW"
   "WW"
   Front Face:
   "GG"
   "GG"
   Right Face:
   "RR"
   "RR"
   Back Face:
   "BB"
   "BB"
   Left Face:
   "OO"
   "OO"
   Down Face:
   "YY"
   "YY"
   Solution for cube #1: Ui Ri Fi Bi Li Di
   ~~~

   

   ~~~
   ./IDAStarLinear pdb_3x3_6.dat 3 scramble_3x3.txt DEBUG
   
   Solving cube #1
   Scrambled Cube:
   Up Face:
   "OBB"
   "OWG"
   "WOG"
   Front Face:
   "BGR"
   "WGR"
   "BYY"
   Right Face:
   "WRO"
   "WRY"
   "OYY"
   Back Face:
   "WWG"
   "BBY"
   "GRY"
   Left Face:
   "WWR"
   "OOG"
   "BBR"
   Down Face:
   "YGG"
   "OYR"
   "OBR"
   Starting IDA* search...
   After applying solution moves, cube state:
   Up Face:
   "WWW"
   "WWW"
   "WWW"
   Front Face:
   "GGG"
   "GGG"
   "GGG"
   Right Face:
   "RRR"
   "RRR"
   "RRR"
   Back Face:
   "BBB"
   "BBB"
   "BBB"
   Left Face:
   "OOO"
   "OOO"
   "OOO"
   Down Face:
   "YYY"
   "YYY"
   "YYY"
   Solution for cube #1: Di Li Fi Bi Ri Ui
   
   Solving cube #2
   Scrambled Cube:
   Up Face:
   "WOB"
   "OWB"
   "OGG"
   Front Face:
   "BWW"
   "YGG"
   "YRB"
   Right Face:
   "ORW"
   "YRW"
   "YYO"
   Back Face:
   "RBG"
   "RBW"
   "YYG"
   Left Face:
   "RWW"
   "BOO"
   "RGG"
   Down Face:
   "OGR"
   "OYR"
   "YBB"
   Starting IDA* search...
   After applying solution moves, cube state:
   Up Face:
   "WWW"
   "WWW"
   "WWW"
   Front Face:
   "GGG"
   "GGG"
   "GGG"
   Right Face:
   "RRR"
   "RRR"
   "RRR"
   Back Face:
   "BBB"
   "BBB"
   "BBB"
   Left Face:
   "OOO"
   "OOO"
   "OOO"
   Down Face:
   "YYY"
   "YYY"
   "YYY"
   Solution for cube #2: D L F B R U
   ~~~

   




### Input File

An input file generator is Implemented in `GenerateInput.hs`.

Usage: 

~~~
./GenerateInput <filename> <number_of_lines> <moves_per_line>
~~~

The input file generated by the program contains multiple lines, each representing a sequence of moves to scramble a Rubik's Cube.

- **Format**:
  
  - Each line consists of move types separated by a comma and a space.
  - Example Line:
    ```
    F, R, U, L, D, B, Fi, Ri, Ui, Li, Di, Bi
    ```
  
- **Move Types**:
  
  - **Clockwise Moves**: `U` (Up), `R` (Right), `F` (Front), `D` (Down), `L` (Left), `B` (Back)
  - **Counterclockwise Moves**: `Ui` (Up inverse), `Ri` (Right inverse), `Fi` (Front inverse), `Di` (Down inverse), `Li` (Left inverse), `Bi` (Back inverse)
  
- **Parameters**:
  
  1. **File Name**: The name/path of the file to be generated (e.g., `scrambles.txt`).
  2. **Number of Lines**: The total number of scramble sequences (each line corresponds to one scrambled cube).
  3. **Number of Moves per Line**: The number of moves in each scramble sequence.
  
- **Usage Example**:
  - To generate an input file named `scrambles.txt` with 100 scramble sequences, each consisting of 25 moves:
    ```bash
    ./GenerateInput scrambles.txt 100 25
    ```

- **Sample Content (`scrambles.txt`)**:
  
    ```
    F, R, U, L, D, B, Fi, Ri, Ui, Li, Di, Bi, F, R, U, L, D, B, Fi, Ri, Ui, Li, Di, Bi, F
    R, F, U, D, L, B, Ri, Fi, Ui, Di, Li, Bi, R, F, U, D, L, B, Ri, Fi, Ui, Di, Li, Bi, R
    ...
    ```
