{-# LANGUAGE OverloadedStrings #-}
import System.Environment (getArgs)
import System.Random (randomRIO)
import System.IO (writeFile)
import Control.Monad (replicateM)

-- | Available moves for a Rubik's cube. 
-- F  = Front 90° clockwise
-- Fi = Front 90° counterclockwise
-- R, Ri, U, Ui, B, Bi, L, Li, D, Di defined similarly.
allMoves :: [String]
allMoves = ["F","Fi","R","Ri","U","Ui","B","Bi","L","Li","D","Di"]

main :: IO ()
main = do
    args <- getArgs
    case args of
      [filename, nStr, mStr] -> do
        let n = read nStr :: Int        -- Number of lines
            m = read mStr :: Int        -- Moves per line
        linesContent <- replicateM n (randomMoveLine m)
        writeFile filename (unlines linesContent)
      _ -> putStrLn "Usage: GenerateInput <filename> <number_of_lines> <moves_per_line>"

-- | Generate a single line of moves.
-- Picks 'm' random moves from 'allMoves' and joins them by ", ".
randomMoveLine :: Int -> IO String
randomMoveLine m = do
    moves <- replicateM m randomMove
    return $ joinBy ", " moves

-- | Pick a random move from allMoves.
randomMove :: IO String
randomMove = do
    idx <- randomRIO (0, length allMoves - 1)
    return (allMoves !! idx)

-- | Utility to join a list of strings with a given separator.
joinBy :: String -> [String] -> String
joinBy sep = foldr1 (\a b -> a ++ sep ++ b)