module Maze (readMaze, findStart, findGoal) where

import Data.Maybe (fromJust)
import Data.List (elemIndex)

-- ** Read the maze from a file
readMaze :: FilePath -> IO [[Char]]
readMaze filename = do
    content <- readFile filename
    return (lines content)

-- ** Find the start position 's' in the maze
findStart :: [[Char]] -> (Int, Int)
findStart maze = 
    let rowIndex = fromJust $ elemIndex True (map (elem 's') maze)
        colIndex = fromJust $ elemIndex 's' (maze !! rowIndex)
    in (rowIndex, colIndex)

-- ** Find the goal position 'g' in the maze
findGoal :: [[Char]] -> (Int, Int)
findGoal maze = 
    let rowIndex = fromJust $ elemIndex True (map (elem 'g') maze)
        colIndex = fromJust $ elemIndex 'g' (maze !! rowIndex)
    in (rowIndex, colIndex)

-- ** Modify the maze with the path
{-
markPath :: [[Char]] -> [(Int, Int)] -> [[Char]]
markPath maze path =
    [ [ if (r, c) == (startRow, startCol) then 's'  
        else if (r, c) == (goalRow, goalCol) then 'g'  
        else if (r, c) `elem` path then '*'  
        else maze !! r !! c  
      | (c, _) <- zip [0..] row] 
    | (r, row) <- zip [0..] maze ]  
  where
    (startRow, startCol) = findStart maze
    (goalRow, goalCol) = findGoal maze  
-}