module DFSCommon (getNeighbors) where

-- ** Get possible moves from the current position (Up, Down, Left, Right)
getNeighbors :: [[Char]] -> (Int, Int) -> [(Int, Int)]
getNeighbors maze (row, col) = 
    let possibleMoves = [(row - 1, col), (row + 1, col), (row, col - 1), (row, col + 1)] 
        validMove (r, c) = r >= 0 && r < length maze && c >= 0 && c < length (maze !! 0) 
                           && (maze !! r !! c == ' ' || maze !! r !! c == 'g')
    in filter validMove possibleMoves
