module Sequential (sequentialDFS) where

import Data.List ((\\))
import DFSCommon

-- ** Sequential DFS
sequentialDFS :: [[Char]] -> (Int, Int) -> (Int, Int) -> [(Int, Int)] -> [(Int, Int)]
sequentialDFS maze start goal visited
    | start == goal = [start]  
    | start `elem` visited = []  
    | otherwise = 
        let newVisited = start : visited 
            neighbors = getNeighbors maze start \\ visited  
            paths = [sequentialDFS maze n goal newVisited | n <- neighbors]  
            nonEmptyPaths = filter (not . null) paths  
        in if null nonEmptyPaths 
            then []  
            else start : head nonEmptyPaths  
