module Main(main) where

import Sequential (sequentialDFS)
import System.Environment (getArgs)
import System.CPUTime (getCPUTime)
import Maze

-- ** Measure Execution Time
measureTime :: IO a -> IO (a, Double)
measureTime action = do
    startTime <- getCPUTime
    result <- action
    endTime <- getCPUTime
    let diff = fromIntegral (endTime - startTime) / (10^12)
    return (result, diff)

-- ** Main function to run both DFS versions and collect data
main :: IO ()
main = do
    args <- getArgs
    let filename = head args
    maze <- readMaze filename
    let start = findStart maze
    let goal = findGoal maze
    putStrLn "Maze layout:"
    putStrLn $ unlines maze
    putStrLn $ "Start: " ++ show start ++ ", Goal: " ++ show goal

    -- Run Sequential DFS
    putStrLn "Running Sequential DFS..."
    let path = sequentialDFS maze start goal []
{-
    -- Mark the path in the maze
    let mazeWithPath = markPath maze path
    putStrLn "Maze with path:"
    putStrLn $ unlines mazeWithPath
-}
    -- Measure Sequential DFS Time
    (_, seqTime) <- measureTime $ return path
    putStrLn $ "Sequential DFS Time: " ++ show seqTime ++ " seconds"

    if null path 
        then putStrLn "No path found"
        else putStrLn $ "Path Found" 
