module Main(main) where

import ParallelDFS (parallelDFS)
import System.Environment (getArgs)
import System.CPUTime (getCPUTime)
import Maze
import Data.Set (empty)

-- ** Measure Execution Time
measureTime :: IO a -> IO (a, Double)
measureTime action = do
    startTime <- getCPUTime
    result <- action
    endTime <- getCPUTime
    let diff = fromIntegral (endTime - startTime) / (10^12)
    return (result, diff)


-- ** Main function to run both DFS versions and collect data
runSolver :: String -> Int -> Int -> IO ()
runSolver filename threads depth = do
    maze <- readMaze filename
    let start = findStart maze
    let goal = findGoal maze
    putStrLn "Maze layout:"
    putStrLn $ unlines maze
    putStrLn $ "Start: " ++ show start ++ ", Goal: " ++ show goal

    -- Run Parallel DFS
    putStrLn "Running Parallel DFS..."
    path <- parallelDFS maze [[start]] goal empty threads depth  -- Extract result from IO

    -- Measure Parallel DFS Time
    (_, seqTime) <- measureTime $ return path
    putStrLn $ "Parallel DFS Time: " ++ show seqTime ++ " seconds"

    if null path 
        then putStrLn "No path found"
        else putStrLn "Found Path "  -- Optionally, you can print the path here as well

main :: IO ()
main = do
    args <- getArgs
    case args of
        [filename, threads, depth] -> runSolver filename (read threads :: Int) (read depth :: Int)
        _ -> putStrLn "usage: parallel-dfs <filename> <threads> <max depth>"
