import System.Exit (exitFailure)

import MDVector

checkEqual :: Eq a => a -> a -> IO ()
checkEqual val1 val2 =
  if val1 == val2
  then return ()
  else exitFailure

checkDouble :: Double -> Double -> IO ()
checkDouble d1 d2 =
  if abs (d1 - d2) < 1e-10
  then return ()
  else exitFailure

main :: IO ()
main = do
  let oneVector = MDVector 1.0 1.0 1.0
      twoVector = MDVector 2.0 2.0 2.0
      threeVector = MDVector 3.0 3.0 3.0
      oneFiveVector = MDVector 1.5 1.5 1.5
      someVector = MDVector 8.0 7.0 1.0
  checkDouble 0.0 0.0
  checkEqual zeroVector zeroVector
  checkEqual oneVector (vectorAdd oneVector zeroVector)
  checkEqual twoVector (vectorAdd oneVector oneVector)
  checkEqual oneVector (vectorSubtract twoVector oneVector)
  checkEqual twoVector (vectorMultiply 2.0 oneVector)
  checkDouble 12.0 (dotProduct twoVector twoVector)
  checkDouble 3.0 (vectorNorm (MDVector 1.0 2.0 2.0))
  checkEqual oneVector (displacement twoVector threeVector 5.0)
  checkEqual (vectorMultiply (-1.0) oneVector) (displacement threeVector twoVector 5.0)
  checkEqual oneFiveVector (displacement threeVector oneVector 3.5)
  checkEqual (vectorMultiply (-1.0) oneFiveVector) (displacement oneVector threeVector 3.5)
  checkDouble 5.0 (distance oneVector someVector 10)
  checkDouble 1.0 (vectorNorm (unitVector someVector))
  checkDouble (vectorNorm someVector) (dotProduct (unitVector someVector) someVector)
