import System.Exit (exitFailure)

import MDVector
import InitialConditions

checkEqual :: Eq a => a -> a -> IO ()
checkEqual val1 val2 =
  if val1 == val2
  then return ()
  else exitFailure

checkDouble :: Double -> Double -> IO ()
checkDouble d1 d2 =
  if abs (d1 - d2) < 1e-10
  then return ()
  else exitFailure

main :: IO ()
main = do
  let initPos = cubicPositions 2.0
      zeroVel = zeroVelocity 2.0
      oneVel = oneVelocity 2.0 1.0
  checkDouble 0.0 0.0
  checkEqual zeroVector zeroVector
  checkEqual 8 (length initPos)
  checkEqual 8 (length zeroVel)
  checkEqual 8 (length oneVel)
  checkDouble (3.0 + 3.0 * (sqrt 2.0) + (sqrt 3.0)) $ sum (map vectorNorm initPos)
  checkDouble 0.0 $ head (map vectorNorm zeroVel)
  checkDouble 0.0 $ sum (map vectorNorm zeroVel)
  checkDouble (sqrt 3.0) $ head (map vectorNorm oneVel)
  checkDouble 0.0 $ sum (tail (map vectorNorm oneVel))
