import System.Exit (exitFailure)

import MDVector
import MDEngine
import InitialConditions

checkEqual :: Eq a => a -> a -> IO ()
checkEqual val1 val2 =
  if val1 == val2
  then return ()
  else exitFailure

checkListEqual :: Eq a => [a] -> [a] -> IO ()
checkListEqual [] [] = return ()
checkListEqual _ [] = exitFailure
checkListEqual [] _ = exitFailure
checkListEqual (a:as) (b:bs)
  | a == b = checkEqual as bs
  | otherwise = exitFailure

main :: IO ()
main = do
  let boxLength = 5.0
      cubicCrystal = cubicPositions boxLength
      crystalForce = forceMatrix cubicCrystal boxLength
  checkListEqual crystalForce $ map (\_ -> zeroVector) crystalForce
