module InitialConditions
  ( cubicPositions,
    zeroVelocity,
    oneVelocity
  ) where

import MDVector

-- Generates list with values for each coordinate in cubic lattice
getRange :: Double -> [Double]
getRange boxLength =
  map fromIntegral [0..(numParticles-1)]
  where numParticles = floor boxLength :: Int

-- Generates cubic initial configuration
cubicPositions :: Double -> [MDVector]
cubicPositions boxLength =
  [ MDVector x y z | x <- range , y <- range , z <- range ]
  where range = getRange boxLength

-- Generates zero initial velocities
zeroVelocity :: Double -> [MDVector]
zeroVelocity boxLength =
  [ MDVector 0 0 0 | _ <- range , _ <- range , _ <- range ]
  where range = getRange boxLength

-- Generates mostly zero initial velocities but gives particle 1 some velocity based on the provided temperature.
oneVelocity :: Double -> Double -> [MDVector]
oneVelocity boxLength temp =
  (MDVector temp temp temp) : tail (zeroVelocity boxLength)
