module Main (main) where

import System.Exit (die)
import System.Environment (getArgs, getProgName)

import MDEngine
import InitialConditions

main :: IO ()
main =
  do args <- getArgs
     case args of
       [timestepsString,boxLengthString,tempString] -> do
         let timesteps = read timestepsString :: Int
             boxLength = read boxLengthString :: Double
             temp = read tempString :: Double
             r0 = cubicPositions boxLength
             v0 = oneVelocity boxLength temp
             firstTraj = mdTraj r0 v0 timesteps boxLength
         putStr $ unlines (map show firstTraj)
       _ -> do pn <- getProgName
               die $ "Usage: " ++ pn ++ " <timesteps> <boxLength> <temperature>"
