# molecular-dynamics

To build the project, run `stack build`.

The following command will compute the self-intermediate scattering function for `$timesteps` simulation timesteps for a Lennard-Jones cube with `$boxLength` particles on each side. The quantitative `$temperature` parameter is defined in the report. Obviously you can also tune `$numThreads`. The results are printed to `stdout`.

`stack exec molecular-dynamics-isf ${timesteps} ${boxLength} ${temperature} -- +RTS -A32M -N${numThreads}` -RTS

NOTE: The runtimes presented in the final report are with the `-A32M` flag as above, but this can be changed to adjust the nursery size.

Alternatively, you can compute the trajectory of the first particle and print it to `stdout` with the following command.

`stack exec molecular-dynamics-traj ${timesteps} ${boxLength} ${temperature} -- +RTS -A32M -N${numThreads}` -RTS

To run the test suite, just run:

`stack test`

## File description

These are the Haskell source files that I wrote for this project (excluding test files, which are all in the `test/` directory):

- `src/MDVector.hs`: defines functions that act on the fundamental `MDVector` datatype used in this project
- `src/MDEngine.hs`: computes forces and updates positions and velocities
- `src/InitialConditions.hs`: generates intial positions and velocities for the Lennard-Jones cubic crystal
- `app/isf/Main.hs`: computes the self-intermediate scattering function and prints it to `stdout`
- `app/traj/Main.hs`: computes the trajectory of the first particle and prints it to to `stdout`

`plots.ipynb` is a Jupyter notebook that takes all of the data generated above and produces the plots that I put in the report and in my presentation.

`vector_attempt.zip` contains my attempt at re-implementing everything with `Data.Vector`, as we discussed during my presentation.
