module InitialConditions
  ( cubicPositions,
    zeroVelocity,
    oneVelocity
  ) where

import qualified Data.Vector.Unboxed as U
import MDVector

-- Generates list with values for each coordinate in cubic lattice
getRange :: Double -> [Double]
getRange boxLength =
  map fromIntegral [0..(numParticles-1)]
  where numParticles = floor boxLength :: Int

-- Generates cubic initial configuration
cubicPositions :: Double -> MDMatrix
cubicPositions boxLength =
  U.fromList [ (x,y,z) | x <- range , y <- range , z <- range ]
  where range = getRange boxLength

-- Generates zero initial velocities
zeroVelocity :: Double -> MDMatrix
zeroVelocity boxLength =
  U.fromList [ zeroVector | _ <- range , _ <- range , _ <- range ]
  where range = getRange boxLength

-- Generates mostly zero initial velocities but gives particle 1 some velocity based on the provided temperature.
oneVelocity :: Double -> Double -> MDMatrix
oneVelocity boxLength temp =
  U.fromList ( (temp,temp,temp) : zeroListTail )
  where range = getRange boxLength
        zeroListTail = tail [ zeroVector | _ <- range , _ <- range , _ <- range ]
