module Main (main) where

import System.Exit (die)
import System.Environment (getArgs, getProgName)
import Text.Printf (printf)

import MDVector
import MDEngine
import InitialConditions

main :: IO ()
main =
  do args <- getArgs
     case args of
       [timestepsString,boxLengthString,tempString] -> do
         let timesteps = read timestepsString :: Int
             boxLength = read boxLengthString :: Double
             temp = read tempString :: Double
             r0 = cubicPositions boxLength
             v0 = oneVelocity boxLength temp
             kval = 2.0 * pi * 10
             k = (kval,kval,kval) :: MDVector
             isfTraj = mdIsf r0 v0 timesteps boxLength k
         putStr $ unlines $ map (\d -> printf "%.3f" d) isfTraj
       _ -> do pn <- getProgName
               die $ "Usage: " ++ pn ++ " <timesteps> <boxLength> <temperature>"
