module ParNaive
    ( tspSearch
    ) where

import AStarLib
import Structures
-- import System.IO

import qualified Data.HashSet as HashSet
import qualified Data.Set as Set
-- import qualified Data.Map as Map
import qualified Data.PQueue.Min as PQ
import Data.Maybe (fromJust)
import Data.List
import Control.Parallel.Strategies

-- Assume 0 heuristic for simpler code.
-- Parallel and apply strategies (?)
-- Points of parallelism? The recursive call on parAstarSearch. -> hard because queue is dependent on previous state and this
-- impl isn't truly recursive.
-- I think the only way is by sharding the top level frontier.
-- If we want some low-level parallelism, I suppose we could speed up the successor evaluation?

tspSearch :: CityGraph -> Route
tspSearch cityGraph = Route (path bestNode)
  where
    cities = getCities cityGraph
    goalState = Set.fromList cities
    startCity = head cities -- is this actually arbitrary. Start at 0 to be consistent with serial impl?
    -- shard depth is the recursion depth of the initial node.
    -- The degree of parallelism should be = cities^^depth 
    -- Shard depth = 1 at least finishes fast enough.
    shardDepth = 1
    -- Create the starting node states (this is the dimension where we shard the work)
    startingNodes = createStartingNodes cityGraph goalState startCity shardDepth
    -- Create the work shards
    -- shards = fmap (\node -> tspShard cityGraph goalState startCity node) startingNodes
    shards = fmap (\node -> tspShard cityGraph goalState startCity node) startingNodes `using` parList rdeepseq
    -- shards = runEval (parMap (\node -> tspShard cityGraph goalState startCity node) startingNodes)

    -- Consolidate the results from the workshards
    bestNode = getBestNode shards

-- CityGraph -> goalState -> startCity -> depth -> starting node list
-- Expands the state space to the 'depth'. Returns the list of resulting nodes. Use this function with care.
-- It can explode by O(cities^^depth)
createStartingNodes :: CityGraph -> Set.Set City -> City -> Int -> [Node]
createStartingNodes _ _ startCity 0 = [Node startCity [startCity] 0 0]
createStartingNodes cityGraph goalState startCity depth = concatMap (\node -> expandNode node cityGraph goalState startCity) (createStartingNodes cityGraph goalState startCity (depth-1)) 

-- A shard of the TSP exploration space, independent from other shards.
-- CityGraph -> goalState -> startCity (always 0 basically) -> startNode of this shard -> returned best Node
tspShard :: CityGraph -> Set.Set City -> City -> Node -> Node
tspShard cityGraph goalState startCity initialNode = parAstarSearch frontier HashSet.empty cityGraph goalState startCity
    where
        frontier = PQ.singleton initialNode

getBestNode :: [Node] -> Node
getBestNode [] = Node 0 [] 0 0 -- should never happen
getBestNode nodes = PQ.findMin (PQ.fromList nodes)

parAstarSearch :: PQ.MinQueue Node -> HashSet.HashSet (City, Set.Set City) -> CityGraph -> Set.Set City -> City -> Node
parAstarSearch frontier visitedStates cityGraph goalState startCity
  | PQ.null frontier = Node startCity [] 9999999999 9999999999 -- return a clearly bad solution so it gets removed from filtering.
  | isGoal currentNode goalState startCity = currentNode
  | HashSet.member (currentCity, currentVisited) visitedStates = parAstarSearch restQueue visitedStates cityGraph goalState startCity
  | otherwise = parAstarSearch newFrontier newVisitedStates cityGraph goalState startCity
  where
    (currentNode, restQueue) = fromJust (PQ.minView frontier)
    currentCity = city currentNode
    currentVisited = Set.fromList (path currentNode)
    newVisitedStates = HashSet.insert (currentCity, currentVisited) visitedStates
    successors = expandNode currentNode cityGraph goalState startCity
    newFrontier = foldr PQ.insert restQueue successors
