-- Main.hs
----------
module Main (main) where

import Structures
import ParNaive 
import ParQueueProcessing
import Serial

import System.Environment
import System.Exit
import System.IO


main :: IO ()
main = do
  args <- getArgs
  case args of
    [edges_file, mode] -> do
      --  putStrLn $ "Starting to parse... " ++ edges_file
      putStrLn $ "Running search in mode: " ++ mode
      edges_contents <- readFile edges_file
      let edges = getEdgesFromLines (lines edges_contents)
          cityGraph = getCityGraphFromEdges edges
          bestRoute = case mode of 
            "parattempt1" -> ParNaive.tspSearch cityGraph
            "parattempt3" -> ParQueueProcessing.tspSearch cityGraph
            _ -> Serial.tspSearch cityGraph 
      -- putStrLn $ "cityGraph Structure: " ++ (show cityGraph)
      putStrLn $ "Found best route: " ++ show bestRoute


 
    _ -> do pn <- getProgName
            hPutStrLn stderr $ "Usage: " ++ pn ++ " <edges-file> <mode>"
            exitFailure

