import numpy as np
import matplotlib.pyplot as plt

total_cores = 12
serial_time_ms = 20800

data_zero = np.loadtxt("timings-zero-heuristic.csv", delimiter=",")
data_tsp = np.loadtxt("timings-tsp-heuristic.csv", delimiter=",")

cores = data_zero[:, 0]
times_zero = data_zero[:, 1]
times_tsp = data_tsp[:, 1]
speedups_zero = times_zero[0] / times_zero
speedups_tsp = times_tsp[0] / times_tsp

serial_line = times_zero[0] / serial_time_ms

plt.plot(cores, speedups_zero, color="C0", label="heuristic: 0")
plt.plot(cores, speedups_tsp, color="C2", label="heuristic: TSP")
plt.axhline(y=serial_line, color="C1", linestyle="--", label="Serial")
plt.axvline(x=total_cores, color="k", linestyle=":", label="Physical cores")
plt.legend()

plt.ylabel("speedup over n=1")
plt.xlabel("$n$ cores")
plt.title("Effect of Heuristic")

plt.xticks(list(range(1, 21, 2)))

plt.savefig("timings.png", dpi=300)
