import subprocess
import time
import numpy as np

n_pts = list(range(1, 20))
times = []

for n in n_pts:
    start = time.time()
    subprocess.run(
        [
            "../app/Main",
            "../data/17_cities_edges.csv",
            "parattempt3",
            "+RTS",
            f"-N{n}",
        ]
    )
    end = time.time()

    time_ms = int(round((end - start) * 1000))
    times.append(time_ms)

data = np.array([n_pts, times], dtype=np.uint32).T
np.savetxt(
    "timings.csv", data, fmt="%d", delimiter=",", header="n_cores,time_ms"
)
