# a-star-tsp-haskell

Make sure the following stack commands work

```
stack setup
stack build
stack exec a-star-tsp-haskell-exe
stack run
stack install
```

# Run the program

Make sure all the dependencies are install by first running: 

```
stack install
```


Data is under `/data`. You can run the program with the following command. The route is supplied as a string (for simplicity in parsing).

```
stack run <city_data_file> <mode>
```

Example 

```
stack run 'data/five_cities_edges.csv' 'serial'
```

Should have an optimal cost of 19. With optimal route '0 2 1 4 3'

# Other dataset runs

This one has 17 cities (which should be pretty expensive). Optimal cost 2085. Optimal route `'0 3 12 6 7 5 16 13 14 2 10 9 1 4 8 11 15'`

```
stack run 'data/17_cities_edges.csv' 'serial'
```

# For parallel execution

Important! Make sure -N and +RTS flags are passed in correctly for parallel execution.

```
time stack run 'data/17_cities_edges.csv' 'parattempt3' -- +RTS -N8 -s -A32m
```

# Useful datasets Sources

https://people.sc.fsu.edu/~jburkardt/datasets/tsp/tsp.html

