-- compile with ghc -O2 -threaded -outputdir build -o fractal main.hs IOHandler.hs Fractal.hs ParallelBackend.hs RepaBackend.hs

-- to run: ./fractal [mandelbrot/julia] [parallel/repa] [for parallel: seq, parBuffer, parListChunk] [for repa: just include a _] 

import System.Environment
import Fractal
import ParallelBackend
import RepaBackend
import IOHandler
import qualified Data.Array.Repa as R
import Data.Array.Repa ((:.)(..), Z(..))

main :: IO ()
main = do
    args <- getArgs
    case args of
        ["mandelbrot", backend, strategy] -> runFractal mandelbrotIterations backend strategy
        ["julia", backend, strategy]      -> runFractal (juliaIterations (-0.8, 0.156)) backend strategy
        _ -> putStrLn "Usage: main <mandelbrot|julia> <parallel|repa> <strategy>"

runFractal :: (Double -> Double -> Int) -> String -> String -> IO ()
runFractal iterationFn "parallel" strategy = do
    let width = 1920; height = 1080
    let image = computeParallel strategy iterationFn width height (-2.5, 2.0)
    writePPM "output.ppm" image

runFractal iterationFn "repa" _ = do
    let width = 1920; height = 1080
    arr <- computeRepa iterationFn width height (-2.5, 2.0)
    R.deepSeqArray arr $ writePPM "output.ppm" [[ arr R.! (R.Z :. y :. x) | x <- [0 .. width - 1]] | y <- [0 .. height - 1]]
