module RepaBackend (computeRepa) where

import Data.Word (Word8)
import qualified Data.Array.Repa as R
import Fractal (iterationToColor, pixelToCoord)
import Data.Array.Repa ((:.)(..), Z(..))

computeRepa :: (Double -> Double -> Int) -> Int -> Int -> (Double, Double) -> IO (R.Array R.U R.DIM2 (Word8, Word8, Word8))
computeRepa iterationFn width height bounds =
    R.computeUnboxedP $ R.fromFunction (Z :. height :. width) $ \(Z :. y :. x) ->
        let (re, im) = pixelToCoord x y width height bounds
        in iterationToColor (iterationFn re im)
