module ParallelBackend (computeParallel) where

import Data.Word (Word8)
import Control.Parallel.Strategies
import Fractal (iterationToColor, pixelToCoord)

computeParallel :: String -> (Double -> Double -> Int) -> Int -> Int -> (Double, Double) -> [[(Word8, Word8, Word8)]]
computeParallel strategy iterationFn width height bounds =
    let rows = [ [ iterationToColor (iterationFn re im)
                  | x <- [0 .. width - 1]
                  , let (re, im) = pixelToCoord x y width height bounds ]
                | y <- [0 .. height - 1] ]
    in case strategy of
         "seq"           -> rows
         "parListChunk"  -> rows `using` parListChunk 8 rdeepseq
         "parBuffer"     -> rows `using` parBuffer 32 rdeepseq
         _               -> error "Invalid parallel strategy"
