module IOHandler (writePPM) where

import System.IO
import Data.Word (Word8)

writePPM :: FilePath -> [[(Word8, Word8, Word8)]] -> IO ()
writePPM file image = withFile file WriteMode $ \h -> do
    let height = length image
        width  = length (head image)
    hPutStrLn h "P3"
    hPutStrLn h (show width ++ " " ++ show height)
    hPutStrLn h "255"
    mapM_ (\row -> mapM_ (\(r,g,b) -> hPutStr h (show r ++ " " ++ show g ++ " " ++ show b ++ " ")) row >> hPutStrLn h "") image
