/*
* Super simple ram module written with the goal of being synthesizable as
* a RAM block
* Team EmbeddedSequencer - Columbia University
*/
module ram #(parameter MEM_DEPTH = 8192)
(
    input logic clk,
    input we,
    input logic [15:0] addr,
    input logic [15:0] d_in,
    output logic [15:0] d_out
);

logic [15:0] mem [MEM_DEPTH-1:0];

always_ff @(posedge clk) begin
    if(we) begin
        mem[addr] <= d_in;
        d_out <= d_in;
    end else d_out <= mem[addr];
end

endmodule
