/*
 * Game Logic
 * First Edied on April 15 2023 by Zhiyuan Liu
*/

#include <stdio.h>
#include <math.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdint.h>
#include <time.h>
#include "usbkeyboard.h"
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <pthread.h>
#include <signal.h>
#include <string.h>

#define MAX_MESSAGE_SIZE 1024

#define PPU_ADDR 0

// Ground space
#define GROUND_0_L 600
#define GROUND_0_R 616
#define GROUND_1_L 1472
#define GROUND_1_R 1503
#define GROUND_2_L 2144
#define GROUND_2_R 2175
// Keyboard // joystic input
enum key_input{KEY_NONE, KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT, KEY_NEWGAME, KEY_END, KEY_A, KEY_B, KEY_X, KEY_Y};
enum key_input current_key;
// Sound Effect
#define SOUND_JUMP 0
#define SOUND_SLOT 0
#define SOUND_BLOCK 0
#define SOUND_DEAD 0
#define SOUND_NONE 5
#define char_number 8
#define RELEASED 0
#define PRESSED 1
#define DISABLE 0
#define ENABLE 1
#define AZHDAHA 0
#define SOUND 4
#define WALL 8
#define SLOT 12
#define WEAPON 16
#define ELF 20
#define CHAR 24
#define TARGET 28
#define SLOT_MODE 0
#define CATCH_MODE 1
#define BATTLE_MODE 2
#define AZHDAHA_MODE 3
#define CATCH_MODE_START 4
#define AFTER_CATCH 5
#define BOSS_PRE_MODE 6
#define BOSS_PLAY_MODE_0 7
#define BOSS_PLAY_MODE_1 8
#define BOSS_BATTLE_MODE_0 9
#define BOSS_MID_MODE_0 10
#define BOSS_MID_MODE_1 11
#define BOSS_BATTLE_MODE_1 12
#define BOSS_MODE 13
#define SLOT_MODE_WIN 14
#define SLOT_MODE_LOSS 15
#define ONLINE_MODE 16
#define ONLINE_MODE_BATTLE 17
#define BATTLE_PRE_MODE 18
#define ONLINE_PRE_MODE 19

#define BITS_BIAS_18 262144
#define WAIT_BACKGROUND 64

//////////////////////////////lcz

#define BOSS_ANIMATION_0 0
#define BOSS_ANIMATION_1 1
#define BOSS_ANIMATION_2 2
#define BOSS_ANIMATION_3 3


//////////////////////////////////

void reset(void);
void SLOT_MODE_FUNC(void);
void CATCH_MODE_FUNC(void);
void BATTLE_PRE_FUNC(void);
void BATTLE_MODE_FUNC(void);
void AZHDAHA_MODE_FUNC(void);
void CATCH_MODE_START_FUNC(void);
void AFTER_CATCH_FUNC(void);
void BOSS_PRE_MODE_FUNC(void);
void BOSS_PLAY_MODE_0_FUNC(void);
void BOSS_PLAY_MODE_1_FUNC(void);
void BOSS_BATTLE_MODE_0_FUNC(void);
void BOSS_MID_MODE_0_FUNC(void);
void BOSS_MID_MODE_1_FUNC(void);
void BOSS_BATTLE_MODE_1_FUNC(void);
void BOSS_MODE_FUNC(void);
void SLOT_MODE_WIN_FUNC(void);
void SLOT_MODE_LOSS_FUNC(void);
void ONLINE_PRE_MODE_FUNC(void);
void ONLINE_MODE_FUNC(void);

uint32_t generate_fire_location(int num_bits);
// Avalon bus file ind
int vga_ball_fd;

char bgm_test[120] = {1,1,1,1,0,0,0,0,1,1,1,1,0,0,0,0,5,5,5,5,0,0,0,0,5,5,5,5,0,0,0,0,6,6,6,6,0,0,0,0,6,6,6,6,0,0,0,0,5,5,5,5,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,4,0,0,0,0,4,4,4,4,0,0,0,0,3,3,3,3,0,0,0,0,3,3,3,3,0,0,0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0,0,0,1,1,1,1,0,0,0,0}	;
char bmg_catch[448] = { 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 0, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 };
char bgm_slot[698] = { 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
char bgm_boss[685] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0 };
char bgm_battle[448] = { 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 0, 5, 5, 5, 5, 5, 0, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 5, 5, 5, 5, 5, 0, 5, 5, 5, 5, 5, 0, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 2, 2, 2, 2, 2, 0, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2, 2, 0, 3, 3, 3, 3, 3, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 };


char *bgm_ptr = bgm_slot;
int sound_len = 698;
int count_sound = 0;
int info_001 = 1;
int info_010 = 2;
int info_011 = 3;
int info_100 = 4;

int mark = 0;
int dif_x = 0;
int dif_y = 0;
int block_r = 0;
int block_l = 0;
int frame_counter = 0;
int game_mode = SLOT_MODE;
int elf_count = 0;
int target_x = 0;
int target_y = 0;
int target_v_x = 0;
int target_v_y = 0;
int target_acc_x = 0;
int target_acc_y = 0;
int count_choose = 0;
int sound_flag = 0;
int sound_addr = 0;
int sound_new = 0;
int sound_ind = 0;
int input_test[3] = {};
int char_test[char_number] = {0,0,0,0,0,0,0,0};
int STOP[3] = {0, 0, 0};
int stop_mark = 0;
int STOP_CHAR[8] = {};
int ELF_ACC_X = -1;
int ELF_ACC_Y = -1;
int beat_key = RELEASED;
int attack_key = RELEASED;
int protect_key = RELEASED;
int count_beat = 0;
int catch_mode = 0;
int started = 0;
int hurt = 0;
int start_laohuji = 0;
int add_score = 0;
int caught = 0;
int sum_score = 5000;
int score = 0;
int battle_enable = 0;
int battle_mode = 0;
int x_target = 0;
int y_target = 0;
int elf_y = 32;
int elf_x = 32;
int slot0 = 0, slot1 = 0, slot2 = 0, visible_slot = 1, visible_azhdaha = 0 ,visible_elf = 0;
int count_enemy = 0;

int weapon_attack_en = DISABLE;
int weapon_protect_enemy_en = DISABLE;
int weapon_protect_elf_en = DISABLE;
int elf_visible_en = DISABLE;
int enemy_visible_en = DISABLE;
int elf_fold_en = DISABLE;
int enemy_fold_en = DISABLE;
int target_visible_en = DISABLE;
int azhdaha_visible_en = DISABLE;
int blood_enemy_visible_en = DISABLE;
int blood_elf_visible_en = DISABLE;
int blood_azhdaha_visible_en = DISABLE;
int blood_azhdaha_visble_enbale = DISABLE;
int blood_elf_visble_enbale = DISABLE;
int blood_enemy_visble_enbale = DISABLE;
int wall_visble_enbale = DISABLE;
int slot_visible_en = DISABLE;
int start_to_attack = 0;
int start_to_attack_enemy = 0;
int start_to_protect = 0;
int caught_elf = 0;
int chosen_to_be = 0;
int chosen_to_be_pre = 0;

int blood_percent_azhdaha = 63;
int blood_percent_elf = 20;
int blood_percent_enemy = 20;
int elf_character = 0;
int enemy_character = 0;
int elf_pattern = 0;
int enemy_pattern = 0;
int weapon_x = 0;
int weapon_y = 0;
int weapon_enemy_x = 0;
int weapon_enemy_y = 0;
int weapon_type = 0;
int count_weapon = 0;
int count_weapon_enemy = 0;

int words_index = 0;
int coin = 10;


int LV = 1;
int ATK = 10;
int ATK_grow = 3;
int DEF = 4;
//int DEF_grow = 2;


int weapon_mark_x = 0;
int weapon_mark_y = 0;
int battle_win_count = 0;
int battle_loss_count = 0;
int count_pre_catch = 0;
int count_after_catch = 0;
int boss_pre_count = 0;
int boss_down_count = 0;
int boss_up_count = 0;

//////////////////////////////////lcz
int boss_state = 0;
int boss_state_counter = 0;
uint32_t boss_fire_location = 0;
//////////////////////////////////
int hit_count = 0;


//////////////////////////////////
int port = 8080;
int ishost = 0;
int sockfd = 0;
int newsockfd = 0;
char message[MAX_MESSAGE_SIZE];

int sync_cnt = 0;

#define OL_INIT     1
#define OL_WAIT     2
#define OL_START    3
#define OL_END      4

int ol_state = 1;

int op_enemy_pre = 0;
int op_enemy = 0;
int hp_me = 0;
int hp_enemy = 0;
int dmg_enemy = 0;




void sigintHandler(int signum) {
    printf("Received SIGINT (Ctrl+C). Cleaning up and exiting...\n");
    // cleanup();
    if(sockfd > 0)
        close(sockfd);
    if(newsockfd > 0)
        close(newsockfd);
    exit(EXIT_SUCCESS);
}



/// @param score 
void score_2_array(int score);
void reset_slot(void);

void write_2_hw(int addr, uint32_t info)
{
	vga_ball_arg_t vla;
	vla.addr = addr;
	vla.info = info;
	if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      		perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      		return;
	}
}


//Keyboard
// input from device
  	libusb_context *ctx = NULL; // a libusb session
  	libusb_device **devs;       // pointer to pointer of device, used to retrieve a list of devices
  	int r;                      // for return values
  	ssize_t cnt;                // holding number of devices in list
	struct libusb_device_handle *mouse;   // a mouse device handle


// Threads================
pthread_t input_thread;
pthread_t sound_thread;
void *input_thread_f(void *);
void *sound_thread_f(void *);

int damage(){
	int lv = LV;
	if(lv > 100) lv = 100;
	int val = ATK + (lv-1) * ATK_grow;
}


void error(const char *msg) {
    perror(msg);
    exit(1);
}

void *clientHandler(void *arg) {
    int sockfd = *((int *)arg);
    char buffer[MAX_MESSAGE_SIZE];
    int n;

    while (1) {
        memset(buffer, 0, sizeof(buffer));
        n = read(sockfd, buffer, sizeof(buffer));
        if (n < 0) 
            error("ERROR reading from socket");
        if (n == 0) {
            printf("Connection closed by client.\n");
            break;
        }

        // printf("he says: %s\n", buffer);

        if(!ishost){
            switch(buffer[0]){
                case 'h':
                    if(ol_state == OL_WAIT){
                        ol_state = OL_START;
                    }
                    break;
                case 's':
                    op_enemy_pre = op_enemy;
                    op_enemy = (buffer[1] - '0')*2 + buffer[2] - '0';                    
                    hp_enemy = (buffer[3] - '0')*100 + (buffer[4] - '0')*10 + buffer[5] - '0';
                    hp_me = (buffer[6] - '0')*100 + (buffer[7] - '0')*10 + buffer[8] - '0';
                    // printf("host op:%d, host hp:%d, my hp:%d\n", op_enemy, hp_enemy, hp_me);
                    break;
                default:
                    printf("unkonw message:%s \n", buffer);
            }
        }else{
            switch(buffer[0]){
                case 'h':
                    if(ol_state == OL_INIT){
                        ol_state = OL_START;
                        dmg_enemy = (buffer[1] - '0')*100 + (buffer[2] - '0')*10 + buffer[3] - '0';    
                        printf("enemy dmg:%d\n", dmg_enemy);
                        strcpy(message, "hello from host");
                        write(newsockfd, message, strlen(message));
                    }
                    break;
                case 's':
                    op_enemy_pre = op_enemy;
                    op_enemy = (buffer[1] - '0')*2 + buffer[2] - '0';
                    // printf("client op:%d\n", op_enemy);
                    break;
                default:
                    printf("unkonw message:%s \n", buffer);
            }
        }

    }

    close(sockfd);
    pthread_exit(NULL);
}


void *serverThread(void *arg) {

    pthread_t tid;
    int ret;
    struct sockaddr_in serv_addr;
    struct sockaddr_in cli_addr;
    socklen_t clilen;
    // Server mode
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) 
        error("ERROR opening socket");

    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(port);

    if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) 
        error("ERROR on binding");

    listen(sockfd, 5);
    clilen = sizeof(cli_addr);

    printf("Server started. Listening on port %d...\n", port);
    // loop to find all in-screen element first
    // ====================================

    while(1){

        newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr, &clilen);
        if (newsockfd < 0){
            error("ERROR on accept");
            close(sockfd);
            close(newsockfd);
            exit(1);
        }

        printf("Connection accepted from %s:%d\n", inet_ntoa(cli_addr.sin_addr), ntohs(cli_addr.sin_port));

        ret = pthread_create(&tid, NULL, clientHandler, &newsockfd);
        if (ret != 0) {
            fprintf(stderr, "Error creating thread\n");
            close(sockfd);
            close(newsockfd);
            exit(1);
        }
    }


    close(sockfd);
    pthread_exit(NULL);

}



int main(int argc, char * argv[]) {
    
    pthread_t tid;
    int ret;
    struct sockaddr_in serv_addr;
    

    signal(SIGINT, sigintHandler);

    //Set up========================
    int err, col;
    static
    const char filename[] = "/dev/vga_ball";
    int ping_pong = 0;
    int random_data;
    srand(time(NULL));
    block_r = 0;
    block_l = 0;

    // Game OBJ
    /* Open the keyboard */
    // if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
    // 	fprintf(stderr, "Did not find a keyboard\n");
    // 	exit(1);
    // }

    r = libusb_init( & ctx); // initialize a library session
    if (r < 0) {
        printf("%s  %d\n", "Init Error", r); // there was an error
        return 1;
    }
    libusb_set_debug(ctx, 3); // set verbosity level to 3, as suggested in the documentation
    cnt = libusb_get_device_list(ctx, & devs); // get the list of devices
    if (cnt < 0) {
        printf("%s\n", "Get Device Error"); // there was an error
    }
    mouse = libusb_open_device_with_vid_pid(ctx, 0x0079, 0x0011);
    if (mouse == NULL) {
        printf("%s\n", "Cannot open device");
        libusb_free_device_list(devs, 1); // free the list, unref the devices in it
        libusb_exit(ctx); // close the session
        return 0;
    } else {
        printf("%s\n", "Device opened");
        libusb_free_device_list(devs, 1); // free the list, unref the devices in it
        if (libusb_kernel_driver_active(mouse, 0) == 1) { // find out if kernel driver is attached
            printf("%s\n", "Kernel Driver Active");
            if (libusb_detach_kernel_driver(mouse, 0) == 0) // detach it
                printf("%s\n", "Kernel Driver Detached!");
        }
        r = libusb_claim_interface(mouse, 0); // claim interface 0 (the first) of device (mine had just 1)
        if (r < 0) {
            printf("%s\n", "Cannot Claim Interface");
            return 1;
        }
    }
    printf("%s\n", "Claimed Interface");

    // Open Avalon bus
    if ((vga_ball_fd = open(filename, O_RDWR)) == -1) {
        fprintf(stderr, "could not open %s\n", filename);
        return -1;
    }

    /////////////////////////////////////
    /* Start the network thread */
    pthread_create( & input_thread, NULL, input_thread_f, NULL);
    //pthread_create(&longpress_thread, NULL, longpress_thread_f, NULL);

    //write_2_hw(6, (uint32_t)(((200 & 0x3FF)<< 22) + ((200 & 0x3FF)<< 12) + ((0 & 0x3F)<< 6) + ((0 & 0x1F)<< 1) + 1));
    //write_2_hw(12, (uint32_t)(((200 & 0x3FF)<< 22) + ((200 & 0x3FF)<< 12) + ((0 & 0x3F)<< 6) + ((0 & 0x1F)<< 1) + 1));
    // Start a new game 
    for (int i = 0; i < 3; ++i) {
        STOP[i] = 0;
    }

    write_2_hw(SOUND, (int)(0));

    if( argc < 2){
        error("two args needed");
        return 1;
    } else if (argc > 2) {
        port = atoi(argv[2]);
    	// Client mode
    	if (argc < 2) {
    	    fprintf(stderr,"Usage: %s server_ip\n", argv[0]);
    	    exit(1);
    	}

    	sockfd = socket(AF_INET, SOCK_STREAM, 0);
    	if (sockfd < 0) {
    	    error("ERROR opening socket");
            exit(1);
        }

    	memset(&serv_addr, 0, sizeof(serv_addr));
    	serv_addr.sin_family = AF_INET;
    	serv_addr.sin_port = htons(port);
    	if (inet_pton(AF_INET, argv[1], &serv_addr.sin_addr) <= 0){
    	    error("ERROR invalid server IP");
            close(sockfd);
            exit(1);
        }

    	if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
            error("ERROR connecting");
            close(sockfd);
            exit(1);
        }
    	    

    	ret = pthread_create(&tid, NULL, clientHandler, &sockfd);
    	if (ret != 0) {
    	    fprintf(stderr, "Error creating thread\n");
    	    close(sockfd);
    	    exit(1);
    	}


    } else {
        port = atoi(argv[1]);

        ishost = 1;
        pthread_t server_tid;
        if (pthread_create(&server_tid, NULL, serverThread, NULL) != 0) {
            fprintf(stderr, "Error creating server thread\n");
            exit(EXIT_FAILURE);
        }
    }

    while (1) {

        //**********************************************************************************************************************************************//
        //
        //
        // SHOW target
        //
        //**********************************************************************************************************************************************//

        if (game_mode > 6 && game_mode < 14) {
            //printf("target invisi\n");
            write_2_hw(TARGET, (uint32_t)(((target_x & 0x3FF) << 22) + ((target_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((0 & 0x1F) << 1) + 0));
            target_x += 4 * target_v_x;
            target_y += 4 * target_v_y;
        } else {
            write_2_hw(TARGET, (uint32_t)(((target_x & 0x3FF) << 22) + ((target_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((0 & 0x1F) << 1) + 1));
            target_x += target_v_x;
            target_y += target_v_y;
        }

        //**********************************************************************************************************************************************//
        //
        //
        // SHOW CHAR 
        //
        //**********************************************************************************************************************************************//
        score_2_array(12345678);
        // write_2_hw(CHAR, (uint32_t)((((((((char_test[7])*16 + char_test[6])*16 + char_test[5])*16+char_test[4])*16+char_test[3])*16+char_test[2])*16+char_test[1])*16+char_test[0]));
        write_2_hw(CHAR, (uint32_t)((((coin * 256 + LV) * 256) + ATK) * 256 + DEF));

        if (game_mode == BATTLE_MODE) {
            BATTLE_MODE_FUNC();
        }

        if (game_mode == SLOT_MODE_WIN) {
            SLOT_MODE_WIN_FUNC();
        }

        if (game_mode == SLOT_MODE_LOSS) {
            SLOT_MODE_LOSS_FUNC();
        }

        if (game_mode == SLOT_MODE) {
            SLOT_MODE_FUNC();
        }

        if (game_mode == CATCH_MODE) {
            CATCH_MODE_FUNC();
        }

        if (game_mode == CATCH_MODE_START) {
            CATCH_MODE_START_FUNC();
        }

        if (game_mode == ONLINE_MODE) {
            ONLINE_MODE_FUNC();
        }

        if (game_mode == BOSS_MODE) {
            BOSS_MODE_FUNC();
        }

        if (game_mode == BOSS_PLAY_MODE_0) {
            BOSS_PLAY_MODE_0_FUNC();
        }

        if (game_mode == BOSS_PLAY_MODE_1) {
            BOSS_PLAY_MODE_1_FUNC();
        }

        if (game_mode == BOSS_BATTLE_MODE_0) {
            BOSS_BATTLE_MODE_0_FUNC();
        }

        if (game_mode == AFTER_CATCH) {
            AFTER_CATCH_FUNC();
        }

        if (game_mode == BATTLE_PRE_MODE){
            BATTLE_PRE_FUNC();
        }

        if (game_mode == ONLINE_PRE_MODE){
            ONLINE_PRE_MODE_FUNC();
        }

        //**********************************************************************************************************************************************//
        //
        //
        // RESTART
        //
        //**********************************************************************************************************************************************//

        if (current_key == KEY_NEWGAME) {
            game_mode = SLOT_MODE;
            coin = 10;
            LV = 1;
            ATK = 10;
            DEF = 4;
            reset();
        }
        reset_slot();
        //**********************************************************************************************************************************************//
        //
        //
        // COUNT BEAT 
        //
        //**********************************************************************************************************************************************//

        if (1) {

            if (1) {
                switch (current_key) {
                case KEY_LEFT:
                    target_v_x -= 1;
                    break;
                case KEY_RIGHT:
                    target_v_x += 1;
                    break;
                case KEY_UP:
                    target_v_y -= 1;
                    break;
                case KEY_DOWN:
                    target_v_y += 1;
                    break;
                case KEY_Y:
                    game_mode = SLOT_MODE;
                    if (!started) {
                        //write_2_hw(WALL, (uint32_t)(0));
                        sum_score -= 20;
                        //write_2_hw(WALL, (uint32_t)(128 * 2048));						
                    }
                    started = 1;

                    break;
                case KEY_X:

                    if ((target_x + 8) > 32 && (target_x + 8) < 64 && (target_y + 8) > 32 && (target_y + 8) < 42) {
                        game_mode = SLOT_MODE;
                        reset();
                    }
                    if ((target_x + 8) > 72 && (target_x + 8) < 112 && (target_y + 8) > 32 && (target_y + 8) < 42) {
                        game_mode = CATCH_MODE;
                        reset();
                    }
                    if ((target_x + 8) > 120 && (target_x + 8) < 168 && (target_y + 8) > 32 && (target_y + 8) < 42) {
                        game_mode = BATTLE_PRE_MODE;
                        reset();
                    }
                    if ((target_x + 8) > 176 && (target_x + 8) < 224 && (target_y + 8) > 32 && (target_y + 8) < 42) {
                        game_mode = BOSS_MODE;
                        reset();
                    }
                    if ((target_x + 8) > 216 && (target_x + 8) < 252 && (target_y + 8) > 32 && (target_y + 8) < 42) {
                        game_mode = ONLINE_PRE_MODE;
                        reset();
                    }
                    break;
                case KEY_B:
                    if (stop_mark == 0) {
                        STOP[count_choose] = 1;
                        count_choose++;
                        stop_mark = 1;
                        if (count_choose == 3) start_laohuji = 1;
                        sound_addr = 2;
                        sound_flag = 1;

                    }
                    if (game_mode == BATTLE_MODE || game_mode == ONLINE_MODE || game_mode == BOSS_BATTLE_MODE_0 || game_mode == BOSS_BATTLE_MODE_1) {
                        if (protect_key == RELEASED) {
                            chosen_to_be = 2;
                        }
                        protect_key = PRESSED;
                    }
                    started = 0;
                    break;
                case KEY_A: //fix
                    if (beat_key == RELEASED) {
                        if (((target_y + 8) - (elf_y + 64)) < 100 && ((target_y + 8) - (elf_y + 64)) > -100 &&
                            ((target_x + 8) - (elf_x + 64) < 100) && ((target_x + 8) - (elf_x + 64)) > -100) {
                            count_beat++;
                            hurt = 1;
                            //sound_addr ++;
                            sound_addr = 1;
                            sound_flag = 1;
                        }
                        beat_key = PRESSED;
                    }
                    if (game_mode == BATTLE_MODE || game_mode == ONLINE_MODE || game_mode == BOSS_BATTLE_MODE_0 || game_mode == BOSS_BATTLE_MODE_1) {
                        if (attack_key == RELEASED) {
                            chosen_to_be = 1;
                            mark = 1;
                        }
                        attack_key = PRESSED;
                    }
                    break;
                    // Shut down
                    // Shut down
                default:
                    target_v_x = 0;
                    target_v_y = 0;
                    stop_mark = 0;
                    hurt = 0;
                    mark = 0;
                    beat_key = RELEASED;
                    attack_key = RELEASED;
                    protect_key = RELEASED;
                }
                if (target_v_x > 3) target_v_x = 3;
                if (target_v_y > 3) target_v_y = 3;
                if (target_v_x < -3) target_v_x = -3;
                if (target_v_y < -3) target_v_y = -3;
                if (target_y < 32) target_y = 32;
                if (target_x < 32) target_x = 32;
                if (target_x > 608 && (game_mode < 6 || game_mode > 13)) target_x = 608;
                if (target_y > 400 && (game_mode < 6 || game_mode > 13)) target_y = 400;
                if (target_x > 480 && (game_mode > 6 && game_mode < 13)) target_x = 480;
                if (target_y > 288 && (game_mode > 6 && game_mode < 13)) target_y = 288;
            }
        }

        write_2_hw(SOUND, (int)(bgm_ptr[(count_sound / 2) % sound_len]));
        count_sound++;
        /*
        		if (sound_flag == 1){
        		  write_2_hw(SOUND, (int)(sound_addr));
        		  if(count_sound == 2){
        		    sound_flag = 0;
        		    count_sound = 0;
        		  }
        		  else{
            		    count_sound++;
        		  }
        		}
        		else{
        		  write_2_hw(SOUND, (int)(0));	
        		}
        */
        //		write_2_hw(SOUND, (int)(sound_addr%8));
        elf_count++;
        usleep(25000);
        //}
    }

    pthread_cancel(input_thread);
    pthread_join(input_thread, NULL);

    close(newsockfd);
    close(sockfd);
    return 0;
}

void BATTLE_PRE_FUNC() {
    blood_percent_elf = 31;
    blood_percent_enemy = 31;
    game_mode = BATTLE_MODE;
    weapon_attack_en = 0;
    weapon_protect_elf_en = 0;
    weapon_protect_enemy_en = 0;
    count_weapon_enemy = 0;
}

void ONLINE_PRE_MODE_FUNC(){
    blood_percent_elf = 31;
    blood_percent_enemy = 31;
    game_mode = ONLINE_MODE;
    weapon_attack_en = 0;
    weapon_protect_elf_en = 0;
    weapon_protect_enemy_en = 0;
    count_weapon_enemy = 0;
}


void *input_thread_f(void *ignored)
{
	unsigned char buff[64];
    int size = 8;
    libusb_interrupt_transfer(mouse, 0x81, buff, 0x0008, &size, 0);
  	for (;;) {
		size = 8;
		libusb_interrupt_transfer(mouse, 0x81, buff, 0x0008, &size, 0);
		if (size == 0x0008){
			
			if (buff[5] == 47) {
				// A:     127 127 0 128 128 47 
				current_key = KEY_A; // printf("JUMP\n");			
			}
			else if (buff[5] == 79) {
				// B:     127 127 0 128 128 79 
				current_key = KEY_B; // printf("JUMP\n");			
			}
			else if (buff[5] == 31) {
				// X:     127 127 0 128 128 31 
				current_key = KEY_X; // printf("JUMP\n");			
			}
			else if (buff[5] == 143) {
				// X:     127 127 0 128 128 31 
				current_key = KEY_Y; // printf("JUMP\n");			
			}
			else if (buff[3] == 0) {
		  		// 127 127 0 128 128 15
		  		// left
				current_key = KEY_LEFT; // printf("LEFT\n");		
			}
			else if (buff[3] == 255) {
				// right
				// 127 127 255 128 128 15 
				current_key = KEY_RIGHT; // printf("RIGHT\n");			
			}
			else if (buff[4] == 0) {
		  		// 127 127 127 0 128 15
		  		// left
				current_key = KEY_UP; // printf("LEFT\n");		
			}
			else if (buff[4] == 255) {
				// right
				// 127 127 127 255 128 15 
				current_key = KEY_DOWN; // printf("RIGHT\n");			
			}
			else if (buff[6] == 32) {
				// restart
				// 127 127 127 127 127 15 32
				current_key = KEY_NEWGAME; // printf("KEY_NEWGAME\n");			
			}
			else{
				current_key = KEY_NONE; // printf("NONE\n");
			}
		}
	}
	return NULL;
}


void reset_slot(){
    if (current_key == KEY_Y ) {
        for(int i = 0; i < 3; ++i){
  	    STOP[i] = 0;
        }
	count_choose = 0;
	stop_mark = 0;
	count_beat = 0;
	beat_key = RELEASED;
	game_mode = SLOT_MODE;
	start_laohuji = 0;
    }
}

void score_2_array(int score){
    int len = 0;
    int score_buff = score;
    
    for(int i = 0; i< char_number; ++i){
        char_test[i] = 0;
    }
    while(score_buff){
        char_test[char_number-1-len] = score_buff % 10;
        score_buff /= 10;
        len++;
    }
}
void reset(){
    for(int i = 0; i < 3; ++i){
     STOP[i] = 0;
        }
    write_2_hw(0, (uint32_t)(0));
    write_2_hw(8, (uint32_t)(0));
    write_2_hw(12, (uint32_t)(0));
    write_2_hw(16, (uint32_t)(0));
    write_2_hw(20, (uint32_t)(0));
    count_beat = 0;
    catch_mode = 0;
    started = 0;
    hurt = 0;
    start_laohuji = 0;
    add_score = 0;
    caught = 0;
    score = 0;
    battle_enable = 0;
    battle_mode = 0;
    x_target = 0;
    y_target = 0;
    elf_y = 32;
    elf_x = 32;
    slot0 = 0;
    slot1 = 0;
    slot2 = 0;
    visible_slot = 1;
    visible_azhdaha = 0;
    visible_elf = 0;
    count_enemy = 0;
    weapon_attack_en = DISABLE;
    weapon_protect_enemy_en = DISABLE;
    weapon_protect_elf_en = DISABLE;
    elf_visible_en = DISABLE;
    enemy_visible_en = DISABLE;
    elf_fold_en = DISABLE;
    enemy_fold_en = DISABLE;
    target_visible_en = DISABLE;
    azhdaha_visible_en = DISABLE;
    blood_enemy_visible_en = DISABLE;
    blood_elf_visible_en = DISABLE;
    blood_azhdaha_visible_en = DISABLE;
    blood_azhdaha_visble_enbale = DISABLE;
    blood_elf_visble_enbale = DISABLE;
    blood_enemy_visble_enbale = DISABLE;
    wall_visble_enbale = DISABLE;
    slot_visible_en = DISABLE;
    start_to_attack = 0;
    start_to_attack_enemy = 0;
    start_to_protect = 0;
    caught_elf = 0;
    chosen_to_be = 0;
    blood_percent_azhdaha = 63;
    blood_percent_elf = 31;
    blood_percent_enemy = 31;
    elf_character = 0;
    enemy_character = 0;
    elf_pattern = 0;
    enemy_pattern = 0;
    weapon_x = 0;
    weapon_y = 0;
    weapon_enemy_x = 0;
    weapon_enemy_y = 0;
    weapon_type = 0;
    count_weapon = 0;
    count_weapon_enemy = 0;

    words_index = 0;


    weapon_mark_x = 0;
    weapon_mark_y = 0;
    battle_win_count = 0;
    battle_loss_count = 0;
    count_pre_catch = 0;
    count_after_catch = 0;
    boss_pre_count = 0;
    boss_down_count = 0;
    boss_up_count = 0;

    DEF = 4;
    hit_count = 0;
}



void SLOT_MODE_FUNC() {
    if (bgm_ptr != bgm_slot) {
        bgm_ptr = bgm_slot;
        sound_len = sizeof(bgm_slot) / sizeof(char);
        count_sound = 0;
        printf("enter slot mode\n");
    }

    if (STOP[0] == 0)
        slot0 = rand();
    if (STOP[1] == 0)
        slot1 = rand();
    if (STOP[2] == 0)
        slot2 = rand();

    if ((slot0 % 2) == (slot1 % 2) && (slot0 % 2) == (slot2 % 2) && STOP[0] == 1 && STOP[1] == 1 && STOP[2] == 1 && start_laohuji == 1) {
        slot_visible_en = 0;
        write_2_hw(SLOT, (uint32_t)((((slot2 % 4 + 1) & 0x3F) << 18) + (((slot1 % 4 + 1) & 0x3F) << 12) + (((slot0 % 4 + 1) & 0x3F) << 6) + ((0 & 0x1F) << 1) + slot_visible_en & 0x1));
        visible_elf = 1;
        start_laohuji = 0;
        game_mode = CATCH_MODE;
        count_choose = 0;
        for (int i = 0; i < 3; ++i) {
            STOP[i] = 0;
        }
    } else {
        if (((slot0 % 2) == (slot1 % 2) || (slot0 % 2) == (slot2 % 2) || (slot1 % 2) == (slot2 % 2)) && STOP[0] == 1 && STOP[1] == 1 && STOP[2] == 1 && start_laohuji == 1) {
            sum_score += 20;
            start_laohuji = 0;
            if (coin > 0)
                coin--;
            if (coin == 0) {
                game_mode = BOSS_MODE;
            }
            //write_2_hw(WALL, (uint32_t)(0));
            //write_2_hw(WALL, (uint32_t)(64 * 2048));	
        }
        //write_2_hw(WALL,(uint32_t)(64*2048));

        slot_visible_en = 1;
        write_2_hw(SLOT, (uint32_t)((slot2 % 2 + 1) * 128 + (slot1 % 2 + 1) * 16 + (slot0 % 2 + 1) * 2 + slot_visible_en));
        //**********************************************************************************************************************************************//
        // elf reset in  SLOT_MODE
        //**********************************************************************************************************************************************//
        elf_visible_en = DISABLE;
        enemy_visible_en = DISABLE;
        elf_fold_en = DISABLE;
        enemy_fold_en = DISABLE;
        elf_character = 1;
        enemy_character = 1;
        elf_pattern = 0;
        enemy_pattern = 0;
        write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
        //**********************************************************************************************************************************************//
        // blood reset in  SLOT_MODE
        //**********************************************************************************************************************************************//
        blood_percent_elf = 31;
        blood_percent_enemy = 31;
        blood_elf_visble_enbale = DISABLE;
        blood_enemy_visble_enbale = DISABLE;
        wall_visble_enbale = DISABLE;
        write_2_hw(WALL, (uint32_t)(96 * BITS_BIAS_18 + blood_percent_elf * 512 + blood_percent_enemy * 16 + 0 * 8 + blood_elf_visble_enbale * 4 + blood_enemy_visble_enbale * 2 + wall_visble_enbale));
        //**********************************************************************************************************************************************//
        // WEAPON reset in  SLOT_MODE
        //**********************************************************************************************************************************************// 
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + 0));
        //**********************************************************************************************************************************************//
        // AZHDAHA reset in  SLOT_MODE
        //**********************************************************************************************************************************************// 
        write_2_hw(AZHDAHA, (uint32_t)(((0 & 0x3FF) << 22) + ((0 & 0x3FF) << 12) + (((1) & 0x3F) << 6) + ((0 & 0x1F) << 1) + 0));
    }
}


void CATCH_MODE_FUNC() {
    count_beat = 0;
    if (bgm_ptr != bmg_catch) {
        bgm_ptr = bmg_catch;
        sound_len = sizeof(bmg_catch) / sizeof(char);
        count_sound = 0;
        printf("enter catch mode\n");
    }

    write_2_hw(WEAPON, (uint32_t)(0));
    count_pre_catch++;
    write_2_hw(WALL, (uint32_t)(2 * BITS_BIAS_18));
    write_2_hw(AZHDAHA, (uint32_t)(0));
    write_2_hw(ELF, (uint32_t)(0));
    write_2_hw(SLOT, (uint32_t)(0));
    if (count_pre_catch == WAIT_BACKGROUND) {
        write_2_hw(WALL, (uint32_t)(0));
        //write_2_hw(WALL,(uint32_t)(4*2048));
        game_mode = CATCH_MODE_START;
        count_pre_catch = 0;
    }
}

void BATTLE_MODE_FUNC() {
    if (bgm_ptr != bgm_battle) {
        bgm_ptr = bgm_battle;
        sound_len = sizeof(bgm_battle) / sizeof(char);
        count_sound = 0;
        printf("enter battle mode\n");
    }

    write_2_hw(AZHDAHA, (uint32_t)(0));
    slot_visible_en = 0;
    write_2_hw(SLOT, (uint32_t)(0));

    if (elf_count % 10 < 5) {
        enemy_visible_en = ENABLE;
        elf_visible_en = ENABLE;
        elf_fold_en = DISABLE;
        enemy_fold_en = ENABLE;
        elf_character = 1;
        enemy_character = 0;
        elf_pattern = 0;
        enemy_pattern = 1;
        write_2_hw(ELF, (uint32_t)(((32 & 0x3FF) << 22) + ((288 & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en & 0x1) << 3) + ((elf_fold_en & 0x1) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    } else {
        enemy_visible_en = ENABLE;
        elf_visible_en = ENABLE;
        elf_fold_en = DISABLE;
        enemy_fold_en = ENABLE;
        elf_character = 0;
        enemy_character = 1;
        elf_pattern = 0;
        enemy_pattern = 1;
        write_2_hw(ELF, (uint32_t)(((32 & 0x3FF) << 22) + ((288 & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en & 0x1) << 3) + ((elf_fold_en & 0x1) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    }
    //**********************************************************************************************************************************************//
    // blood test in  BATTLE_MODE
    //**********************************************************************************************************************************************//
    blood_azhdaha_visble_enbale = DISABLE;
    blood_elf_visble_enbale = ENABLE;
    blood_enemy_visble_enbale = ENABLE;
    wall_visble_enbale = DISABLE;
    write_2_hw(WALL, (uint32_t)(24 * BITS_BIAS_18 + blood_percent_elf * 512 + blood_percent_enemy * 16 + 0 * 8 + blood_elf_visble_enbale * 4 + blood_enemy_visble_enbale * 2 + wall_visble_enbale));

    if (chosen_to_be == 1) {
        start_to_attack = 1;
        weapon_attack_en = 1;
        weapon_protect_elf_en = 0;
    } else if (chosen_to_be == 2) {
        start_to_attack = 2;
        weapon_attack_en = 0;
        weapon_protect_elf_en = 1;
    }
    if(start_to_attack == 0){
        weapon_attack_en = 0;
    }

    //**********************************************************************************************************************************************//
    // weapon in  BATTLE_MODE
    //**********************************************************************************************************************************************//
    if (start_to_attack == 1) {
        weapon_x = 130 + count_weapon * 4;
        weapon_y = 400;
        weapon_type = 3;
        int rightmost = 416;
        if(!weapon_protect_enemy_en){
            rightmost = 530;
        }

        if (weapon_x > rightmost) {
            write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + 0));
        }else{
            write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));

        }

        if (weapon_x > rightmost) {
            start_to_attack = 0;
            //weapon_x = 130;
            chosen_to_be = 0;
            if (weapon_protect_enemy_en == 0) {
                int dmg = damage();
                blood_percent_enemy -= dmg; //fix
                if (blood_percent_enemy < 1) {
                    game_mode = SLOT_MODE_WIN;
                    for (int i = 0; i < 3; ++i) {
                        STOP[i] = 0;
                    }
                    start_laohuji = 0;
                    //stop_mark = 0;
                    count_choose = 0;
                }
            }
            count_weapon = 0;
            write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + 0));

        }
        count_weapon++;
    }

    if (start_to_attack == 2) {

        count_weapon = 0;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        chosen_to_be = 0;

    }
    if (start_to_attack_enemy == 2 && count_enemy == 50) {
        start_to_attack_enemy = rand() % 2 + 1;
        count_enemy = 0;
    }
    if (start_to_attack_enemy == 0) {
        start_to_attack_enemy = rand() % 2 + 1;
        count_enemy = 0;
    }

    if (start_to_attack_enemy == 1) {
        weapon_protect_enemy_en = 0;
        weapon_enemy_x = 520 - (count_weapon_enemy * 4);
        weapon_enemy_y = 380;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        write_2_hw(SLOT, (uint32_t)(((weapon_enemy_x & 0x3FF) << 22) + ((weapon_enemy_y & 0x3FF) << 12) + 1024));

        int leftmost = 210;
        if(!weapon_protect_elf_en){
            leftmost = 140;
        }


        if (weapon_enemy_x < leftmost) {
            start_to_attack_enemy = 0;
            weapon_enemy_x = 160;
            if (weapon_protect_elf_en < 1) {
                blood_percent_elf -= 1;
                if (blood_percent_elf == 0) {
                    game_mode = SLOT_MODE;
                    for (int i = 0; i < 3; ++i) {
                        STOP[i] = 0;
                    }
                    start_laohuji = 0;
                }
            }
            count_weapon_enemy = 0;
            write_2_hw(SLOT, (uint32_t)(0));
        }
        count_weapon_enemy++;
    }

    if (start_to_attack_enemy == 2) {
        weapon_protect_enemy_en = 1;
        count_weapon_enemy = 0;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        write_2_hw(SLOT, (uint32_t)(0));

    }
    count_enemy++;

    printf("battle attack:%d, chose:%d\n", start_to_attack, chosen_to_be);
    /*             
		        if(start_to_attack_enemy == 2){

		            weapon_enemy_x = 416 - (count_weapon_enemy*4);
		            weapon_enemy_y = 380;
			    write_2_hw(SLOT, (uint32_t)(((weapon_enemy_x & 0x3FF)<< 22) + ((weapon_enemy_y & 0x3FF)<< 12)+2048+1024));
			    if(weapon_enemy_x < 160){
		                 start_to_attack_enemy = 0;

		                 weapon_enemy_x = 160;
				if(weapon_protect_elf_en == 0){
				   blood_percent_elf -=1;
		                   if(blood_percent_elf == 0) {
		                      game_mode = SLOT_MODE;
				      for(int i = 0; i < 3; ++i){
	  	                          STOP[i] = 0;
		                      }
		                      start_laohuji = 0;
		                   }
		                }
				   count_weapon_enemy = 0;
			        write_2_hw(SLOT, (uint32_t)(0));
		            }
		          count_weapon_enemy ++;
		        }*/
}

void AZHDAHA_MODE_FUNC(void);

void CATCH_MODE_START_FUNC() { //fix
    slot_visible_en = 0;
    write_2_hw(SLOT, (uint32_t)(0));
    if (elf_x < 32) ELF_ACC_X = 1;
    else if (elf_x > 608 - 128) ELF_ACC_X = -1;

    if (elf_y < 48) ELF_ACC_Y = 1;
    else if (elf_y > 416 - 128) ELF_ACC_Y = -1;

    elf_x += ELF_ACC_X * 4;
    elf_y += ELF_ACC_Y * 4;
    if (ELF_ACC_X == 1) {
        elf_visible_en = ENABLE;
        enemy_visible_en = DISABLE;
        elf_fold_en = DISABLE;
        enemy_fold_en = DISABLE;
        elf_character = 1;
        enemy_character = 1;
        elf_pattern = 0;
        enemy_pattern = 0;
        write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    } else if (ELF_ACC_X == -1) {
        elf_visible_en = ENABLE;
        enemy_visible_en = DISABLE;
        elf_fold_en = ENABLE;
        enemy_fold_en = ENABLE;
        elf_pattern = 0;
        enemy_pattern = 1;
        enemy_character = 0;
        elf_character = 1;
        write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    }
    if (count_beat == 3) {
        printf("catch count 3\n");
        LV += 1;
        ATK = damage();
        game_mode = AFTER_CATCH;
        //write_2_hw(WALL, (uint32_t)(0));
        sum_score += 200;
        //write_2_hw(WALL, (uint32_t)(256 * 2048));
        sound_addr = 3;
        sound_flag = 1;
        caught_elf = 1;
        start_laohuji = 0;
        //stop_mark = 0;
        count_choose = 0;
    }

}


void AFTER_CATCH_FUNC() {
    count_after_catch++;
    write_2_hw(WALL, (uint32_t)(128 * BITS_BIAS_18)); //fix
    //**********************************************************************************************************************************************//
    // elf reset in  SLOT_MODE
    //**********************************************************************************************************************************************//
    elf_visible_en = DISABLE;
    enemy_visible_en = DISABLE;
    elf_fold_en = DISABLE;
    enemy_fold_en = DISABLE;
    write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    if (count_after_catch == WAIT_BACKGROUND / 2) {
        write_2_hw(WALL, (uint32_t)(0));
        //write_2_hw(WALL,(uint32_t)(4*2048));
        game_mode = SLOT_MODE;
        count_after_catch = 0;
    }
}

void BOSS_PRE_MODE_FUNC(void);
void BOSS_PLAY_MODE_0_FUNC() { //抬头
    boss_up_count++;
    write_2_hw(AZHDAHA, (uint32_t)((((2) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
    if (boss_up_count == 40) {
        game_mode = BOSS_PLAY_MODE_1;
        boss_up_count = 0;
    }
}
void BOSS_PLAY_MODE_1_FUNC() { //跺脚
    boss_down_count++;
    //write_2_hw(WALL, (uint32_t)(4096*4096*32 + ((10 & 0x1F) << 25) + 96*BITS_BIAS_11 + blood_percent_azhdaha * 256 + blood_percent_elf * 64 + blood_percent_enemy * 16 + blood_azhdaha_visble_enbale * 8 + blood_elf_visble_enbale*4 + wall_visble_enbale*2 + wall_visble_enbale));
    write_2_hw(WALL, (uint32_t)(((10 & 0x1F) << 14) + 8 + 1));
    write_2_hw(AZHDAHA, (uint32_t)((63 << 5) + (((3) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
    if (boss_down_count == 40) {
        game_mode = BOSS_BATTLE_MODE_0;
        boss_down_count = 0;
    }
}

uint32_t generate_fire_location(int num_bits) {
    uint32_t location = 0; // 初始化位置变量，所有位都是0
    int bits_set = 0; // 已设置的位数计数器
    int random_bit;

    // 初始化随机数生成器
    srand(time(NULL));

    while (bits_set < num_bits) {
        random_bit = rand() % 18; // 随机生成一个位的位置

        if (target_x + 128 < (random_bit + 1) * 32 || target_x > (random_bit + 2) * 32) {
            hit_count = hit_count;
        } else {
            hit_count++;
        }
        DEF = 4 - hit_count;
        if(DEF < 0){
            DEF = 0;
        }
        // 检查这个位置是否已经设置了1，如果没有则设置它
        if (!(location & (1 << random_bit))) {
            location |= (1 << random_bit);
            bits_set++;
        }
    }

    return location;
}
void BOSS_BATTLE_MODE_0_FUNC() {
    if (hit_count == 4) {
        game_mode = SLOT_MODE_LOSS;
        hit_count = 0;
        DEF = 4;
    }
    //boss_state = BOSS_ANIMATION_0;
    //boss_fire_location = generate_fire_location(1);

    write_2_hw(ELF, (uint32_t)(((target_x & 0x3FF) << 22) + ((target_y & 0x3FF) << 12) + ((0 & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (0 << 1) + 1));
    //boss_down_count ++;
    //write_2_hw(WALL, (uint32_t)(4096*4096*32 + ((10 & 0x1F) << 25) + 96*BITS_BIAS_11 + blood_percent_azhdaha * 256 + blood_percent_elf * 64 + blood_percent_enemy * 16 + blood_azhdaha_visble_enbale * 8 + blood_elf_visble_enbale*4 + wall_visble_enbale*2 + wall_visble_enbale));
    write_2_hw(WALL, (uint32_t)(((1 & 0x1F) << 14) + 8 + 1));
    //write_2_hw(AZHDAHA, (uint32_t)(((boss_fire_location) << 12) + (blood_percent_azhdaha << 5) + (((3) & 0x3F)<< 2) + ((1 & 0x1F)<< 1) + 1));

    switch (boss_state) {
    case BOSS_ANIMATION_0: {
        write_2_hw(AZHDAHA, (uint32_t)(((boss_fire_location) << 11) + (blood_percent_azhdaha << 5) + (((0) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
        boss_state_counter++;
        if (boss_state_counter == 40) {
            if (blood_percent_azhdaha < 50) {
                boss_fire_location = generate_fire_location(2); // 血量小于50，设置两个位为1
            } else {
                boss_fire_location = generate_fire_location(1); // 血量大于或等于50，设置一个位为1
            }
            boss_state = BOSS_ANIMATION_1;
            boss_state_counter = 0;
        }
        break;
    }

    case BOSS_ANIMATION_1: {
        write_2_hw(AZHDAHA, (uint32_t)(((boss_fire_location) << 11) + (blood_percent_azhdaha << 5) + (((1) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
        boss_state_counter++;
        if (boss_state_counter == 40) {
            if (blood_percent_azhdaha < 50) {
                boss_fire_location = generate_fire_location(2); // 血量小于50，设置两个位为1
            } else {
                boss_fire_location = generate_fire_location(1); // 血量大于或等于50，设置一个位为1
            }
            boss_state = BOSS_ANIMATION_2;
            boss_state_counter = 0;
        }
        break;
    }

    case BOSS_ANIMATION_2: {
        write_2_hw(AZHDAHA, (uint32_t)(((boss_fire_location) << 11) + (blood_percent_azhdaha << 5) + (((2) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
        boss_state_counter++;
        if (boss_state_counter == 40) {
            if (blood_percent_azhdaha < 50) {
                boss_fire_location = generate_fire_location(2); // 血量小于50，设置两个位为1
            } else {
                boss_fire_location = generate_fire_location(1); // 血量大于或等于50，设置一个位为1
            }
            boss_state = BOSS_ANIMATION_3;
            boss_state_counter = 0;
        }
        break;
    }

    case BOSS_ANIMATION_3: {
        write_2_hw(AZHDAHA, (uint32_t)(((boss_fire_location) << 11) + (blood_percent_azhdaha << 5) + (((3) & 0x3F) << 2) + ((1 & 0x1F) << 1) + 1));
        boss_state_counter++;
        if (boss_state_counter == 40) {
            if (blood_percent_azhdaha < 50) {
                boss_fire_location = generate_fire_location(2); // 血量小于50，设置两个位为1
            } else {
                boss_fire_location = generate_fire_location(1); // 血量大于或等于50，设置一个位为1
            }
            boss_state = BOSS_ANIMATION_0;
            boss_state_counter = 0;
        }
        break;
    }

    default: {
        boss_state = BOSS_ANIMATION_0;
    }

    }

    if (chosen_to_be == 1) {
        start_to_attack = 1;
        weapon_attack_en = 1;
        weapon_protect_elf_en = 0;
        if (mark == 1) {
            weapon_mark_x = target_x +64;
            weapon_mark_y = target_y +64;
            weapon_x = target_x + 64;
            weapon_y = target_y + 64;
            dif_x = (320 - weapon_mark_x) / 16;
            dif_y = (300 - weapon_mark_y) / 16;
        }
    }

    if (start_to_attack == 1) {
        weapon_x += dif_x;
        weapon_y += dif_y;
        weapon_type = 3;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + 0 * 4 + 0 * 2 + 1));
        if ((weapon_x > 310 || weapon_x < 330) && (weapon_y > 290 || weapon_y > 310)) {
            start_to_attack = 0;
            weapon_x = target_x;
            weapon_y = target_y;
            chosen_to_be = 0;
            if (1) {
                int dmg = damage();
                printf("dmg:%d\n", dmg);
                blood_percent_azhdaha -= dmg;
                if (blood_percent_azhdaha < 1) { //fix
                    game_mode = SLOT_MODE_WIN;
                    coin += 5;
                    blood_percent_azhdaha = 63;
                    for (int i = 0; i < 3; ++i) {
                        STOP[i] = 0;
                    }
                    start_laohuji = 0;
                    //stop_mark = 0;

                    count_choose = 0;
                }
            }
            count_weapon = 0;
            write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + 0));
        }
        count_weapon++;
    }
}
void BOSS_MID_MODE_0_FUNC(void);
void BOSS_MID_MODE_1_FUNC(void);
void BOSS_BATTLE_MODE_1_FUNC(void);
void BOSS_MODE_FUNC() {
    if (bgm_ptr != bgm_boss) {
        bgm_ptr = bgm_boss;
        sound_len = sizeof(bgm_boss) / sizeof(char);
        count_sound = 0;
        printf("enter boss mode\n");
    }

    slot_visible_en = 0;
    write_2_hw(SLOT, (uint32_t)(0));
    write_2_hw(WEAPON, (uint32_t)(0));
    boss_pre_count++;
    write_2_hw(WALL, (uint32_t)(2048 * BITS_BIAS_18));
    elf_visible_en = DISABLE;
    enemy_visible_en = DISABLE;
    elf_fold_en = DISABLE;
    enemy_fold_en = DISABLE;
    elf_character = 1;
    enemy_character = 1;
    elf_pattern = 0;
    enemy_pattern = 0;
    write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en)); //write_2_hw(AZHDAHA, (uint32_t)(((64 & 0x3FF)<< 22) + ((180 & 0x3FF)<< 12) + (((1) & 0x3F)<< 6) + ((1 & 0x1F)<< 1) + 1));
    if (boss_pre_count == WAIT_BACKGROUND) {
        game_mode = BOSS_PLAY_MODE_0;
        write_2_hw(WALL, (uint32_t)(0));
        boss_pre_count = 0;
        write_2_hw(AZHDAHA, (uint32_t)(((0 & 0x3FF) << 22) + ((0 & 0x3FF) << 12) + (((1) & 0x3F) << 6) + ((1 & 0x1F) << 1) + 1));
    }
}
void SLOT_MODE_WIN_FUNC() {
    battle_win_count++;
    write_2_hw(WALL, (uint32_t)(128 * BITS_BIAS_18));
    write_2_hw(WEAPON, (uint32_t)(0));
    //**********************************************************************************************************************************************//
    // elf reset in  SLOT_MODE
    //**********************************************************************************************************************************************//
    elf_visible_en = DISABLE;
    enemy_visible_en = DISABLE;
    elf_fold_en = DISABLE;
    enemy_fold_en = DISABLE;
    write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    if (battle_win_count == WAIT_BACKGROUND / 2) {
        write_2_hw(WALL, (uint32_t)(0));
        //write_2_hw(WALL,(uint32_t)(4*2048));
        game_mode = SLOT_MODE;
        battle_win_count = 0;
    }
}
void SLOT_MODE_LOSS_FUNC() {

    battle_loss_count++;
    write_2_hw(WEAPON, (uint32_t)(0));
    write_2_hw(WALL, (uint32_t)(256 * BITS_BIAS_18));
    //**********************************************************************************************************************************************//
    // elf reset in  SLOT_MODE
    //**********************************************************************************************************************************************//
    elf_visible_en = DISABLE;
    enemy_visible_en = DISABLE;
    elf_fold_en = DISABLE;
    enemy_fold_en = DISABLE;
    write_2_hw(ELF, (uint32_t)(((elf_x & 0x3FF) << 22) + ((elf_y & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en) << 3) + ((elf_fold_en) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    if (battle_loss_count == WAIT_BACKGROUND / 2) {
        write_2_hw(WALL, (uint32_t)(0));
        //write_2_hw(WALL,(uint32_t)(4*2048));
        if(coin > 0)
            game_mode = SLOT_MODE;
        battle_loss_count = 0;
    }

}
void ONLINE_MODE_FUNC() {

    if (bgm_ptr != bgm_battle) {
        bgm_ptr = bgm_battle;
        sound_len = sizeof(bgm_battle) / sizeof(char);
        count_sound = 0;
        printf("enter online mode\n");
    }

    write_2_hw(AZHDAHA, (uint32_t)(0));
    slot_visible_en = 0;
    write_2_hw(SLOT, (uint32_t)(0));

    if (elf_count % 10 < 5) {
        if(ol_state != OL_START){
            enemy_visible_en = DISABLE;
            enemy_fold_en = DISABLE;
        }else{
            enemy_visible_en = ENABLE;
            enemy_fold_en = ENABLE;
        }

        elf_visible_en = ENABLE;
        elf_fold_en = DISABLE;
        
        elf_character = 1;
        enemy_character = 0;
        elf_pattern = 0;
        enemy_pattern = 0;
        write_2_hw(ELF, (uint32_t)(((32 & 0x3FF) << 22) + ((288 & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en & 0x1) << 3) + ((elf_fold_en & 0x1) << 2) + (enemy_visible_en << 1) + elf_visible_en));
    } 
    else {
         if(ol_state != OL_START){
            enemy_visible_en = DISABLE;
            enemy_fold_en = DISABLE;
        }else{
            enemy_visible_en = ENABLE;
            enemy_fold_en = ENABLE;
        }

        elf_visible_en = ENABLE;
        elf_fold_en = DISABLE;
        
        elf_character = 0;
        enemy_character = 1;
        elf_pattern = 0;
        enemy_pattern = 0;
        write_2_hw(ELF, (uint32_t)(((32 & 0x3FF) << 22) + ((288 & 0x3FF) << 12) + ((enemy_pattern & 0x3) << 10) + ((elf_pattern & 0x3) << 8) + ((enemy_character & 0x3) << 6) + ((elf_character & 0x3) << 4) + ((enemy_fold_en & 0x1) << 3) + ((elf_fold_en & 0x1) << 2) + (enemy_visible_en << 1) + elf_visible_en));
        
    }

    if(ol_state == OL_INIT && !ishost){
        ol_state = OL_WAIT;
        int dmg = damage();
        message[0] = 'h';
        message[1] = (dmg / 100)%10 + '0';
        message[2] = (dmg / 10)%10 + '0';
        message[3] = dmg%10 + '0';
        message[4] = '\0';
        write(sockfd, message, strlen(message));
    }

    if(ol_state != OL_START){
        return;
    }

    //**********************************************************************************************************************************************//
    // blood test in  BATTLE_MODE
    //**********************************************************************************************************************************************//
    blood_azhdaha_visble_enbale = DISABLE;
    blood_elf_visble_enbale = ENABLE;
    blood_enemy_visble_enbale = ENABLE;
    wall_visble_enbale = DISABLE;
    write_2_hw(WALL, (uint32_t)(24 * BITS_BIAS_18 + blood_percent_elf * 512 + blood_percent_enemy * 16 + 0 * 8 + blood_elf_visble_enbale * 4 + blood_enemy_visble_enbale * 2 + wall_visble_enbale));

    if (chosen_to_be == 1) {
        start_to_attack = 1;
        weapon_attack_en = 1;
        weapon_protect_elf_en = 0;
    } else if (chosen_to_be == 2) {
        start_to_attack = 2;
        weapon_attack_en = 0;
        weapon_protect_elf_en = 1;
    }else{
        weapon_attack_en = 0;
    }
    //  else {
    //     start_to_attack = 0;
    //     weapon_attack_en = 0;
    //     weapon_protect_elf_en = 0;
    // }

    // if(start_to_attack == 0){
    //     write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
    // }

    //**********************************************************************************************************************************************//
    // weapon in  BATTLE_MODE
    //**********************************************************************************************************************************************//
    if (start_to_attack == 1) {
        weapon_x = 130 + count_weapon * 4;
        weapon_y = 400;
        weapon_type = 3;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));

        int rightmost = 416;
        if(!weapon_protect_enemy_en){
            rightmost = 530;
        }

        if (weapon_x > rightmost) {
            start_to_attack = 0;
            //weapon_x = 130;
            chosen_to_be = 0;
            if (weapon_protect_enemy_en == 0) {
                int dmg = damage();
                if(ishost){
                    blood_percent_enemy -= dmg; 
                }
                
                if (blood_percent_enemy < 1) {
                    game_mode = SLOT_MODE_WIN;
                    for (int i = 0; i < 3; ++i) {
                        STOP[i] = 0;
                    }
                    start_laohuji = 0;
                    //stop_mark = 0;
                    count_choose = 0;
                }
            }
            count_weapon = 0;
            write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + 0));
        }
        count_weapon++;
    }

    if (start_to_attack == 2) {

        count_weapon = 0;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        chosen_to_be = 0;

    }
    // if (start_to_attack_enemy == 2 && count_enemy == 50) {
    //     start_to_attack_enemy = rand() % 2 + 1;
    //     count_enemy = 0;
    // }
    // if (start_to_attack_enemy == 0) {
    //     start_to_attack_enemy = rand() % 2 + 1;
    //     count_enemy = 0;
    // }
    if(op_enemy != op_enemy_pre){
        start_to_attack_enemy = op_enemy;
        printf("op_enemy:%d, start_to_attack_enemy:%d\n", op_enemy, start_to_attack_enemy);
    }

    if (start_to_attack_enemy == 1) {
        weapon_protect_enemy_en = 0;
        weapon_enemy_x = 520 - (count_weapon_enemy * 4);
        weapon_enemy_y = 380;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        write_2_hw(SLOT, (uint32_t)(((weapon_enemy_x & 0x3FF) << 22) + ((weapon_enemy_y & 0x3FF) << 12) + 1024));

        int leftmost = 210;
        if(!weapon_protect_elf_en){
            leftmost = 140;
        }

        if (weapon_enemy_x < leftmost) {
            start_to_attack_enemy = 0;
            //weapon_enemy_x = 160;
            if (weapon_protect_elf_en < 1) {
                if(ishost){
                    blood_percent_elf -= dmg_enemy;
                }
                printf("0 my blood:%d\n", blood_percent_elf);
                if (blood_percent_elf <= 0) {
                    printf("my blood:%d\n", blood_percent_elf);
                    game_mode = SLOT_MODE_LOSS;
                    for (int i = 0; i < 3; ++i) {
                        STOP[i] = 0;
                    }
                    start_laohuji = 0;
                }
            }
            count_weapon_enemy = 0;
            write_2_hw(SLOT, (uint32_t)(0));
        }
        count_weapon_enemy++;
    }

    
    if (start_to_attack_enemy == 2) {
        weapon_protect_enemy_en = 1;
        count_weapon_enemy = 0;
        write_2_hw(WEAPON, (uint32_t)(((weapon_x & 0x3FF) << 22) + ((weapon_y & 0x3FF) << 12) + ((0 & 0x3F) << 6) + ((weapon_type & 0x7) << 3) + weapon_protect_elf_en * 4 + weapon_protect_enemy_en * 2 + weapon_attack_en));
        write_2_hw(SLOT, (uint32_t)(0));

    }

    // if(sync_cnt % 5 == 0){
        if(ishost){
            int out_elf_hp = blood_percent_elf;
            if(out_elf_hp < 0)
                out_elf_hp = 0;
            int out_enemy_hp = blood_percent_enemy;
            if(out_enemy_hp < 0)
                out_enemy_hp = 0;
            message[0] = 's';
            message[1] = (start_to_attack/2) + '0';
            message[2] = (start_to_attack%2) + '0';
            message[3] = (out_elf_hp / 100)%10 + '0';
            message[4] = (out_elf_hp / 10)%10 + '0';
            message[5] = out_elf_hp%10 + '0';
            message[6] = (out_enemy_hp / 100)%10 + '0';
            message[7] = (out_enemy_hp / 10)%10 + '0';
            message[8] = out_enemy_hp%10 + '0';
            message[9] = '\0';
            write(newsockfd, message, strlen(message));
        }else{
            message[0] = 's';
            message[1] = (start_to_attack/2) + '0';
            message[2] = (start_to_attack%2) + '0';
            message[3] = '\0';
            write(sockfd, message, strlen(message));
        }
    // }

    if(!ishost){
        blood_percent_enemy = hp_enemy;
        blood_percent_elf = hp_me;

        if (blood_percent_enemy < 1) {
            game_mode = SLOT_MODE_WIN;
            for (int i = 0; i < 3; ++i) {
                STOP[i] = 0;
            }
            start_laohuji = 0;
            //stop_mark = 0;
            count_choose = 0;
            return;
        }else if (blood_percent_elf < 1) {
            game_mode = SLOT_MODE_LOSS;
            for (int i = 0; i < 3; ++i) {
                STOP[i] = 0;
            }
            start_laohuji = 0;
            return;
        }
        
    }






    count_enemy++;
    sync_cnt++;




}
