#ifndef CAT_INVADERS_INTERFACE_H
#define CAT_INVADERS_INTERFACE_H

//#include <sys/types.h>
#include "cat_invaders.h"

typedef struct {
    unsigned short x;
    unsigned short y;
} Position;
cat_invaders_arg_t vla;
void init_driver(void);

/*set the dog's x position, y is fixed*/
void set_dog_pos(unsigned short x);

/*dog bullet position x and y, idk what is the visibility used for in hw, but should be added when calling the function*/
void set_projectile_dog_position(unsigned short x, unsigned short y, unsigned short visibility);

/*set the 4 projectile positions for cats. num: 0-3; position x, y*/
void set_projectile_sprite(unsigned char number, unsigned short x, unsigned short y, unsigned short visibility);

/*set the cat matrix position (Left Top position)*/
void set_sprite_pos(unsigned short x, unsigned short y);

/*set ufo's x position, y is fixed*/
void set_ufo_pos(unsigned short x, unsigned short vis);


void set_status(unsigned short level, unsigned short gameStatus, unsigned short
life);
/*set level range: 0-8*/
void set_level(unsigned short value);
/*set lives range: 0-3*/
void set_lives(unsigned short value);
/*set game status: 0: 1: 2: */
void set_gameStatus(unsigned short value);
/*set score range: 0-999*/
void set_score(unsigned short value);


void set_dog_ani(unsigned short state);
void set_cat_ani(unsigned short state);

/*To set the four barrier's state, number 0-23 (0-5, 6-11, 12-17, 18-23 for each barrier respectively)
and status 0-4 (from full to destroyed)  */

void set_barrier(unsigned short number, unsigned short status);
/*set a cat's statue, cat should be 0-54, and status:0-4 */
void set_sprite_matrix(unsigned char target, unsigned short status);

/* volume from 0 - 15*/
void play_background(unsigned char volume);
void play_bark(unsigned char volume);
void play_meow(unsigned char volume);
/*speed ranging from 0 - 6*/
void set_speed(unsigned char speed);
void set_explosion(unsigned short x, unsigned short y, unsigned short visibility);
void clear_irq(unsigned short irq);

unsigned short get_test_reg(void);
unsigned short get_frame_reg(void);

// unsigned char get_bullet(void); 
// unsigned short get_dog_pos(void);
// Position get_projectile_dog(void);
// Position get_projectile_sprites(unsigned char target);
// Position get_sprite_pos(void);
// void get_sprite_matrix(void);
// unsigned short get_ufo_pos(void);
// unsigned char get_misc1(void);
// unsigned short get_score(void);
// unsigned char get_barrier(unsigned char target);
// unsigned char get_animation_dog(void);
// unsigned char get_animation_cat(void);
// unsigned char get_background(void);
// unsigned char get_bark(void);
// unsigned char get_meow(void);

#endif 
