#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <time.h>

#include "interface.h"
#include "cat_invaders.h"
#include "../controller/usbjoypad.h"

#define MIN_X 0
#define MAX_X 640 - 32
#define BONE_START_Y 416
#define BONE_END_Y 24
#define PROJ_SPEED 2
#define MYSTERY_SPEED 1
#define BONE_SPEED 3
#define MYSTERY_Y_POS 50
#define POODLE_Y_POS 430
#define MOUSE_END_Y 500
#define DOG_SPEED 2
#define CAT_SPEED 1
#define BOTTOM_CUTOFF 378 
#define CAT_LEFT_WALL 1
#define CAT_RIGHT_WALL 288 // Only stores the value for the left
#define max(a, b) ((a) > (b) ? (a) : (b))
#define min(a, b) ((a) < (b) ? (a) : (b))

typedef struct {
    unsigned short x1Min;
    unsigned short x1Max;
    unsigned short y1Min;
    unsigned short y1Max;
    unsigned short x2Min;
    unsigned short x2Max;
    unsigned short y2Min;
    unsigned short y2Max;
} CollisionBoxes;

unsigned short dogPos;
unsigned short mysteryPos;
Position catMatPos;
unsigned char explode_cnt[55];
unsigned char numCats;
unsigned short score = 0;
unsigned char level = 1;
unsigned char lives = 3;
unsigned short gameStatus = 0;
Position bonePos;
Position micePos[4];


void init_cat_matrix(unsigned short (*catMatrix)[55]);
void reset_cat_matrix(unsigned short (*catMatrix)[55]);
void *explode_cat(void *catNum);

/* --------------------------------------------------- General Functions --------------------------------------------------- */


// Might need a tracker for cat movement
void *animation_tracker(void *frame) {
    unsigned short *frameNum = (unsigned short *) frame;
    *frameNum = *frameNum == 5 ? 0 : *frameNum + 1;
}
 
void reset_objects(unsigned short (*catMatrix)[55], int *mysterySpawnTime, bool *mysteryInPlay) {
    dogPos = 300;
    catMatPos.x = 40;
    catMatPos.y = 90;
    numCats = 55;
    *mysterySpawnTime = -1;
    *mysteryInPlay = false;
    set_ufo_pos(mysteryPos, 0);

    reset_cat_matrix(catMatrix);
    set_sprite_pos(catMatPos.x, catMatPos.y);
    set_dog_pos(dogPos);
    set_projectile_dog_position(dogPos+16, BONE_START_Y, 0);

    for (int i = 1; i < 4; i++) {
        set_projectile_sprite(i, 0, 0, 0);
    }

     for(int i = 0; i < 55; i++) {
        explode_cnt[i] = 0;
     }

}
 
unsigned short clamp(unsigned short val, unsigned short minV, unsigned short maxV) {
    return (unsigned short) max(min(val, maxV), minV);
}


bool barrier_hit(unsigned short (*barrierMatrix)[24], Position projPos, unsigned
short projW, unsigned short projH) {
    Position barrierStart;
    barrierStart.y = 346;


    for (int j = 0; j < 2; j++) {
        for (int k = 0; k < 12; k++) {
            if ( k >= 9 ) {
                barrierStart.x = 424;
            }
            else if ( k >= 6) { 
                barrierStart.x = 324;
            }
            else if( k >= 3) {
               barrierStart.x = 224;
            }
            else {
                barrierStart.x = 124;
            }


            int barrierNum = k + 12 * j;

            Position blockPos = {barrierStart.x + (16 * (k%3)), barrierStart.y + 16 * j};
            CollisionBoxes collision = {projPos.x, projPos.x + projW,
                projPos.y, projPos.y + projH,
                blockPos.x, blockPos.x + 16, 
                blockPos.y, blockPos.y + 16};

            if ( collision.x1Min < collision.x2Max &&
                collision.x1Max > collision.x2Min &&
                collision.y1Min < collision.y2Max &&
                collision.y1Max > collision.y2Min &&
                (*barrierMatrix)[barrierNum] != 0) {
                    (*barrierMatrix)[barrierNum] = ( (*barrierMatrix)[barrierNum] == 4 ) ? 0  :
                    (*barrierMatrix)[barrierNum] + 1;
                    set_barrier(barrierNum*2, (*barrierMatrix)[barrierNum]);

                    return true;
            }


        }
    }

    return false;
}


void reset_cat_matrix(unsigned short (*catMatrix)[55]) {
    for (int i = 0; i < 55; i++) {
        (*catMatrix)[i] = 0;
        set_sprite_matrix(i*2, 0);
    }
}

void init_cat_matrix(unsigned short (*catMatrix)[55]) {
    time_t t;
    srand((unsigned) time(&t));

    for (int i = 0; i < 55; i++) {
        int status = (rand() % 4) + 1;

        (*catMatrix)[i] = status;
        set_sprite_matrix(i*2, status);
    }
}

void reset_barrier_matrix(unsigned short (*barrierMatrix)[24]) {
    for (int i = 0; i < 24; i++) {
        (*barrierMatrix)[i] = 1;
        set_barrier(i*2, 1);
    }
}

void check_lives( unsigned short (*catMatrix)[55], unsigned short (*barrierMatrix)[24], int *mysterySpawnTime, bool *mysteryInPlay) {
    if( lives == 0) {
        reset_cat_matrix(catMatrix);
        set_status(level, 2, lives);

        while(controller_get_state().startPressed == 0);
        while(controller_get_state().startPressed == 1);

        lives = 3;
        gameStatus = 0;
        score = 0;

        set_score(score);
        level = 1;
        set_status(level, gameStatus, lives);
        reset_objects(catMatrix, mysterySpawnTime, mysteryInPlay);
        reset_barrier_matrix(barrierMatrix);

        while(controller_get_state().startPressed == 0);
        while(controller_get_state().startPressed == 1);

        gameStatus = 1;
        set_status(level, gameStatus, lives);
        init_cat_matrix(catMatrix);
    }
}

/* --------------------------------------------------- General Functions --------------------------------------------------- */
/* --------------------------------------------------- Player Functions --------------------------------------------------- */

void animate_player(unsigned short frame, bool dogDir, bool isWalking) {
    // Frame cycles through 0,1,2:
    
    // Assuming that left is 0-4, right is 5-9
    // Walking animation
    if (isWalking) {
        // Assuming that there is a 2 offset because of the two idle animation frames
        unsigned short walkFrame = 2 + frame % 3;   
        set_dog_ani(dogDir ? walkFrame : walkFrame + 5);
    }
    // Idle animation 
    else {
        // NOTE: Not suse if i can use the dogDirection with the standard that i've placed but-
        unsigned short idleFrame = frame % 2;
        set_dog_ani(dogDir ? idleFrame : idleFrame + 5);
    }

}

void move_player(ControllerState state) {
    // If the player is trying to move left, move if they are not at the boundary.
    if (state.leftArrowPressed && dogPos > MIN_X ) {
        if (dogPos < DOG_SPEED) {
            dogPos = 0;
        }
        else {
            dogPos = clamp(dogPos - DOG_SPEED, 
            (unsigned short) MIN_X, (unsigned short) MAX_X);
        }
        set_dog_pos(dogPos);
    }
    else if (state.rightArrowPressed && dogPos < MAX_X) {
        dogPos = clamp(dogPos + DOG_SPEED, 
        (unsigned short) MIN_X, (unsigned short) MAX_X); 
        set_dog_pos(dogPos);
    }
    
}

void update_player_state(bool *dogDir, bool *isWalking, ControllerState state) {
    if (state.leftArrowPressed) {
        *dogDir = true;
        *isWalking = true;
        return;
    }
    else if (state.rightArrowPressed) {
        *dogDir = false;
        *isWalking = true;
        return;
    }

    *isWalking = false;
}

void update_bone_projectile(ControllerState state, bool *dogInFlight) { 
    // If there is no bullet currently flying and the player presses A
    if (state.buttonAPressed && !(*dogInFlight) ) {
        bonePos.x = dogPos + 16;
        bonePos.y = BONE_START_Y;
        set_projectile_dog_position(bonePos.x, bonePos.y, 1);
        *dogInFlight = true;
        play_bark(0);
    }
    else if ( *dogInFlight ) {
        if (bonePos.y < BONE_END_Y) {
            *dogInFlight = false;
            set_projectile_dog_position(dogPos, BONE_START_Y, 0);
        }
        else { 
            bonePos.y -= BONE_SPEED;
            set_projectile_dog_position(bonePos.x, bonePos.y, 1);
        }
    }

}

void bone_collision(bool *dogInFlight, bool *mysteryInPlay, int *mysterySpawnTime,
unsigned short (*catMatrix)[55], unsigned short (*barrierMatrix)[24]) {
    if (!(*dogInFlight)) {
        return;
    }

    unsigned short catNum = 0;


    // Barrier hit
    if ( barrier_hit(barrierMatrix, bonePos, 8, 24) ) {
        set_projectile_dog_position(dogPos + 16, BONE_START_Y, 0);
        *dogInFlight = false;
        return;
    }
    // Mystery hit
    else if (*mysteryInPlay) {

        CollisionBoxes mysteryCollision = {bonePos.x, bonePos.x + 8,
                                    bonePos.y, bonePos.y + 24,
                                    mysteryPos, mysteryPos + 48, 
                                    MYSTERY_Y_POS, MYSTERY_Y_POS + 48};
        
        if ( mysteryCollision.x1Min < mysteryCollision.x2Max &&
             mysteryCollision.x1Max > mysteryCollision.x2Min &&
             mysteryCollision.y1Min < mysteryCollision.y2Max &&
             mysteryCollision.y1Max > mysteryCollision.y2Min ) {
                 
            *mysteryInPlay = false;
            *mysterySpawnTime = -1;
            score += 10;

            set_ufo_pos(mysteryPos, 0);
            set_projectile_dog_position(dogPos + 16, BONE_START_Y, 0);
            *dogInFlight = false;
        }


    }
   
    // Checking cat collisions
    for (int i = 0; i < 5; i++) {
        for (int j = 0; j < 11; j++) {
            catNum = 11 * i + j;
            Position catPos = {catMatPos.x + 32 * j, catMatPos.y + 32 * i };
            CollisionBoxes collision = {bonePos.x, bonePos.x + 8,
                                       bonePos.y, bonePos.y + 24,
                                       catPos.x, catPos.x + 32, 
                                       catPos.y, catPos.y + 32};

            
            
            // Collision detected between cat 
            if ( collision.x1Min < collision.x2Max &&
                 collision.x1Max > collision.x2Min &&
                 collision.y1Min < collision.y2Max &&
                 collision.y1Max > collision.y2Min &&
                 (*catMatrix)[(int) catNum] != 0 ) {

                (*catMatrix)[(int) catNum] =  0;
                explode_cat(&catNum);

                play_meow(0);
                set_projectile_dog_position(dogPos + 16, BONE_START_Y, 0);
                *dogInFlight = false;

                return;
            }
        }

    }
    
}

/* --------------------------------------------------- Player Functions --------------------------------------------------- */
/* --------------------------------------------------- Cat Functions --------------------------------------------------- */

void *explode_cat(void *catNum) {
    unsigned char *target = (unsigned char *) catNum;
    set_sprite_matrix(*target * 2, 5);
    explode_cnt[*target] = 1;
     
    numCats--;
    (score < 1000) ? score++ : 0;

}

void move_cats(bool *catDir) {
    // Move right
    if (*catDir && catMatPos.x < CAT_RIGHT_WALL) {
        catMatPos.x = clamp(catMatPos.x + CAT_SPEED,
        (unsigned short) CAT_LEFT_WALL, (unsigned short) CAT_RIGHT_WALL);

        set_sprite_pos(catMatPos.x, catMatPos.y);
    }
    // Move left
    else if (!(*catDir) && catMatPos.x > CAT_LEFT_WALL) {
        if (catMatPos.x < CAT_SPEED) {
            catMatPos.x = 0;
        }
        else { 
            catMatPos.x = clamp(catMatPos.x - CAT_SPEED,
            (unsigned short) CAT_LEFT_WALL, (unsigned short) CAT_RIGHT_WALL);
        }

        set_sprite_pos(catMatPos.x, catMatPos.y);
    }
    // Move down
    else if ( ( *catDir && catMatPos.x == CAT_RIGHT_WALL ) ||
            ( !(*catDir) && catMatPos.x == CAT_LEFT_WALL ) ) {
        catMatPos.y += 16;
        set_sprite_pos(catMatPos.x, catMatPos.y);
        *catDir = !(*catDir);
    }
}


void check_all_eliminated(unsigned short (*catMatrix)[55], bool *dogInFlight, bool (*catInFlight)[4], int *mysterySpawnTime, bool *mysteryInPlay) {
    if(numCats == 0) {
            (level<10) ? level++ : 0;
            numCats = 55;
            reset_objects(catMatrix, mysterySpawnTime, mysteryInPlay);
            sleep(2);
            init_cat_matrix(catMatrix);
            
            *dogInFlight = false;
            for (int i = 0; i < 4; i++) {
                (*catInFlight)[i] = false;
            }

            bonePos.x = dogPos + 16;
            bonePos.y =  BONE_START_Y;
            set_projectile_dog_position(bonePos.x, bonePos.y, 0);
            
            for (int i = 1; i < 4; i++) {
                micePos[i].x = 0;
                micePos[i].y = 0;
                set_projectile_sprite(i, micePos[i].x, micePos[i].y, 0);
            }
    }  
}

 void animate_cats(unsigned short frame) {
     set_cat_ani(frame % 2);
 }

unsigned short pick_random_cat(unsigned short catMatrix[55], unsigned short numCats) {
    unsigned short tmp[numCats];
    int counter = 0;
    
    for (int i = 0; i < 55; i++) {
        if (catMatrix[i] != 0) {
            tmp[counter++] = i;
        }
    }
    
    time_t t;
    srand((unsigned) time(&t));
    
    unsigned short randCat = tmp[rand() % numCats];
    return randCat;
    
}

int fire_cat_projectile(bool (*catInFlight)[4], unsigned short catMatrix[55], unsigned short numCats) {
    // Just picks the first available projectile slot
    for (int i = 1; i < 4; i++) {
        if (!((*catInFlight)[i])) {
            (*catInFlight)[i] = true;
            
            // Spawns the selected prjectile
            unsigned short randCat = pick_random_cat(catMatrix, numCats);
                
            Position mousePos = {catMatPos.x + 32 * (randCat % 11) + 16, 
                                    catMatPos.y + ( 32 * ((int) (randCat / 11)) ) + 10};
                                    
            micePos[i].x = mousePos.x;
            micePos[i].y = mousePos.y;
            
            set_projectile_sprite(i, micePos[i].x, micePos[i].y, 1);

            return i;
        }
    }
}

void move_cat_projectile(bool (*catInFlight)[4], int *lastShot) {
    for (int i = 1; i < 4; i++) {
        // Shoots the rest if they are in flight
        if ((*catInFlight)[i] && i != *lastShot) {
            if (micePos[i].y > MOUSE_END_Y) {
                (*catInFlight)[i] = false;
                set_projectile_sprite(i, micePos[i].x, micePos[i].y, 0);
            }
            else {
                micePos[i].y = micePos[i].y + PROJ_SPEED;
                set_projectile_sprite(i, micePos[i].x, micePos[i].y, 1);
            }
        }
    }

    *lastShot = 5;
}

void mouse_collision(bool (*catInFlight)[4], unsigned short (*barrierMatrix)[24]) {
    
    for (int i = 1; i < 4; i++) {
        bool *currentCatInFlight = &((*catInFlight)[i]);
        
        if (!(*currentCatInFlight)) {
            continue; 
        }

    
        // Checking dog collisions
        Position completeDogPos = {dogPos, POODLE_Y_POS};

        CollisionBoxes collision = {micePos[i].x, micePos[i].x + 8,
                                micePos[i].y, micePos[i].y + 16,
                                completeDogPos.x, completeDogPos.x + 32, 
                                completeDogPos.y, completeDogPos.y + 32};


        // Barrier hit
        if ( barrier_hit(barrierMatrix, micePos[i], 8, 16) ) {
            set_projectile_sprite(i, micePos[i].x, micePos[i].y, 0);
            (*catInFlight)[i] = false;
        }   
        // Collision detected between dog
        else if ( collision.x1Min < collision.x2Max &&
            collision.x1Max > collision.x2Min &&
            collision.y1Min < collision.y2Max &&
            collision.y1Max > collision.y2Min) {

            lives--;

            play_bark(0);
            set_projectile_sprite(i, micePos[i].x, micePos[i].y, 0);
            (*catInFlight)[i] = false;
        }
    }
    
}

int pick_mystery_spawn() {
    time_t t;
    srand((unsigned) time(&t));
    int offset = rand() % 6;   

    if (rand() % 2 == 0) {
        offset *= -1;
    }

    return (25 + offset) * 60;
}

void spawn_mystery(bool *mysteryInPlay) {
    printf("Mystery spawned\n");
    *mysteryInPlay = true;
    mysteryPos = 640;
    set_ufo_pos(mysteryPos, 1);
}

void update_mystery(bool *mysteryInPlay, int *mysterySpawnTime) {
    if (*mysteryInPlay) {
        if (mysteryPos != 0) {
            if (mysteryPos < MYSTERY_SPEED) {
                mysteryPos = 0;
            }
            else {
                mysteryPos -= MYSTERY_SPEED;
            }
            
            printf("Mystery Moving: %u\n", mysteryPos);
            set_ufo_pos(mysteryPos, 1);
        }
        else { 
            *mysteryInPlay = false;
            *mysterySpawnTime = -1;

            printf("Mystery despawned\n");
            set_ufo_pos(mysteryPos, 0);
        }
    }
}

void reached_bottom(unsigned short catMatrix[55]) {
    int bottomMostRow;
    bool broke = false;

    for (int i = 4; i >= 0; i--) {
        bottomMostRow = i;

        for (int j = 0; j < 11; j++) {
            int catNum = j + 11 * i;

            if (catMatrix[catNum] != 0) {
                broke = true;
                break;
            }
        } 

        if (broke) {
            break;
        }
    }

    unsigned short bottomY = catMatPos.y + 32 * (bottomMostRow + 1);
    if (bottomY > BOTTOM_CUTOFF) {
        lives = 0;
        printf("Cats reached the bottom, you lose.\n");
    }

}

/* --------------------------------------------------- Cat Functions --------------------------------------------------- */


void start_game() { 
    unsigned short catMatrix[55];
    unsigned short barrierMatrix[24];
    unsigned short tmp = 0;
    int lastShot = 5;

    unsigned short frame = 0;
 
    unsigned long long counter = 0;

    // true = left, false = right
    bool dogDir = true;
    bool catDir = true;

    bool isWalking = false;
    
    bool dogInFlight = false;
    bool catInFlight[4] = {false, false, false, false};
    bool mysteryInPlay = false;
    int mysterySpawnTime = -1;

    controller_init();
    init_driver();

    reset_barrier_matrix(&barrierMatrix);
    reset_objects(&catMatrix, &mysterySpawnTime, &mysteryInPlay);
    set_speed(2);
    play_background(0);

    set_status(level, gameStatus, lives);

    while(controller_get_state().startPressed == 0);
    while(controller_get_state().startPressed == 1);
    init_cat_matrix(&catMatrix);
    gameStatus = 1;


    // Update this thing
    while (true) {
        // Wait
        while( (tmp&0x7FFF) == (get_frame_reg()&0x7FFF));
        tmp = get_frame_reg();

        if(counter % 30 == 0) {
           animation_tracker(&frame);
        }
        counter++;
  

        ControllerState state = controller_get_state();
        update_player_state(&dogDir, &isWalking, state);

        // If the spawn time hasn't been found yet, then pick one
        if (mysterySpawnTime < 0) {
            mysterySpawnTime = pick_mystery_spawn();
            printf("New mystery timer: %i\n", mysterySpawnTime);
        }    

        // 1. Check if all of the cats have been eliminated
        check_all_eliminated(&catMatrix, &dogInFlight, &catInFlight, &mysterySpawnTime, &mysteryInPlay);

        // 2. Check for player collisions (mouse)
        bone_collision(&dogInFlight, &mysteryInPlay, &mysterySpawnTime, &catMatrix, &barrierMatrix);

        // 3. Check for cat collisions (bone)
        mouse_collision(&catInFlight, &barrierMatrix);

        // 4. Move the cats (including animations)
        // Calls move more often when there are less cats.
        if( (numCats != 0) && ( counter % (5 - ( (int) ( ( 55 - numCats ) / 11 )) )  == 0)) {
            move_cats(&catDir);
         }
        if(counter % 60 == 0) {
            // Q: i was 56, was there a reason for that? wouldn't that overflow?
            for(int i = 0; i < 55; i++) {
                if(explode_cnt[i] == 1) {
                    set_sprite_matrix(i * 2, 0);
                    explode_cnt[i] = 0;
                }
                    
            }
         }
         animate_cats(frame);

        // 5. Move the player (including animations)
        move_player(state);
        animate_player(frame, dogDir, isWalking); // Change the frame to the updated thing

        // 6. Fire (if applicable) and move cat projectiles
        if( counter % (330 - (30 * level)) == 0)
            lastShot = fire_cat_projectile(&catInFlight, catMatrix, numCats);
        move_cat_projectile(&catInFlight, &lastShot);
        
        // 7. Fire (if applicable) and move player projectile
        update_bone_projectile(state, &dogInFlight);

        // 8. Update score
        set_score(score);

        // 9. Check if cats reached the bottom
        reached_bottom(catMatrix);

        // 10. Update status
        check_lives(&catMatrix, &barrierMatrix, &mysterySpawnTime, &mysteryInPlay);
        set_status(level, gameStatus, lives); 

        // 11. Update the mystery
        if (counter % mysterySpawnTime == 0)
            spawn_mystery(&mysteryInPlay);
        update_mystery(&mysteryInPlay, &mysterySpawnTime);

    }

}

int main() {
    
    start_game();   

    return 0;
}
