#ifndef _CAT_INVADERS_H
#define _CAT_INVADERS_H

#include <linux/ioctl.h>

/*projectile_dog*/
typedef struct{
    unsigned short p_x;
    unsigned short p_y;
}projectile_dog_t;

/*projectile_cat_sprite*/
typedef struct {
  unsigned short x;
  unsigned short y;
}projectile_cat_t;

typedef struct {
  projectile_cat_t c0;
  projectile_cat_t c1;
  projectile_cat_t c2;
  projectile_cat_t c3;
}projectile_cat_group_t;

typedef struct {
  unsigned short x;
  unsigned short y;
} explosion_t;


/*cat matrix position*/
typedef struct {
  unsigned short x;
  unsigned short y;
}cat_matrix_position_t;

/*score*/
typedef struct{
    unsigned short score_lsb;
    unsigned short score_msb;
}score_t;

/*animation*/
typedef struct {
  unsigned short dog_ani;
  unsigned short cat_ani;
}animation_t;

/*audio*/
typedef struct {
  unsigned short background;
  unsigned short bark;
  unsigned short meow;
  unsigned short speed;
}audio_t;

/*Argument*/
typedef struct {
  unsigned short dog_p_x;
  projectile_dog_t projectile_dog;
  projectile_cat_group_t projectile_cat_group;
  explosion_t explosion;
  cat_matrix_position_t cat_matrix_pos;
  unsigned short mystery_pos_x;
  unsigned short status;
  unsigned short score;
  unsigned short dog_ani;
  unsigned short cat_ani;
  unsigned short barrier_mat; 
  unsigned short cat_mat;
  audio_t audio;
  unsigned short irq;
  unsigned short test_reg;
  unsigned short frame_reg;
} cat_invaders_arg_t;


#define CAT_INVADERS_MAGIC 'q'

/* ioctls and their arguments */
//#define WRITE_MISC_0 _IOW(CAT_INVADERS_MAGIC, 1, cat_invaders_arg_t *)
#define WRITE_DOG_POSITION _IOW(CAT_INVADERS_MAGIC, 1, cat_invaders_arg_t *)
#define WRITE_PROJECTILE_DOG _IOW(CAT_INVADERS_MAGIC, 2, cat_invaders_arg_t *)
#define WRITE_PROJECTILE_CAT_0 _IOW(CAT_INVADERS_MAGIC, 3, cat_invaders_arg_t *)
#define WRITE_PROJECTILE_CAT_1 _IOW(CAT_INVADERS_MAGIC, 4, cat_invaders_arg_t *)
#define WRITE_PROJECTILE_CAT_2 _IOW(CAT_INVADERS_MAGIC, 5, cat_invaders_arg_t *)
#define WRITE_PROJECTILE_CAT_3 _IOW(CAT_INVADERS_MAGIC, 6, cat_invaders_arg_t *)
#define WRITE_CAT_MATRIX_POSITION _IOW(CAT_INVADERS_MAGIC, 7, cat_invaders_arg_t *)
#define WRITE_MYSTERY_POSITION _IOW(CAT_INVADERS_MAGIC, 8, cat_invaders_arg_t *)
#define WRITE_STATUS _IOW(CAT_INVADERS_MAGIC, 9, cat_invaders_arg_t *)
#define WRITE_SCORE _IOW(CAT_INVADERS_MAGIC, 10, cat_invaders_arg_t *)
#define WRITE_BARRIER _IOW(CAT_INVADERS_MAGIC, 11, cat_invaders_arg_t *)
#define WRITE_CAT_MATRIX _IOW(CAT_INVADERS_MAGIC, 12, cat_invaders_arg_t *)
#define WRITE_DOG_ANIMATION _IOW(CAT_INVADERS_MAGIC, 13, cat_invaders_arg_t *)
#define WRITE_CAT_ANIMATION _IOW(CAT_INVADERS_MAGIC, 14, cat_invaders_arg_t *)
#define WRITE_BG _IOW(CAT_INVADERS_MAGIC, 15, cat_invaders_arg_t *)
#define WRITE_BARK _IOW(CAT_INVADERS_MAGIC, 16, cat_invaders_arg_t *)
#define WRITE_MEOW _IOW(CAT_INVADERS_MAGIC, 17, cat_invaders_arg_t *)
#define WRITE_SPEED _IOW(CAT_INVADERS_MAGIC, 18, cat_invaders_arg_t *)
#define CLEAR_IRQ _IOW(CAT_INVADERS_MAGIC, 19, cat_invaders_arg_t *)
#define WRITE_EXPLOSION _IOW(CAT_INVADERS_MAGIC, 20, cat_invaders_arg_t*)

#define READ_TEST_REG _IOR(CAT_INVADERS_MAGIC, 21, cat_invaders_arg_t *)
#define READ_FRAME_REG _IOR(CAT_INVADERS_MAGIC, 22, cat_invaders_arg_t*)

// #define READ_MISC_0 _IOR(CAT_INVADERS_MAGIC, 18, cat_invaders_arg_t *)
// #define READ_DOG_POSITION _IOR(CAT_INVADERS_MAGIC, 19, cat_invaders_arg_t *)
// #define READ_PROJECTILE_DOG _IOR(CAT_INVADERS_MAGIC, 20, cat_invaders_arg_t *)
// #define READ_PROJECTILE_SPRITES _IOR(CAT_INVADERS_MAGIC, 24, cat_invaders_arg_t *)
// #define READ_SPRITE_POSITION _IOR(CAT_INVADERS_MAGIC, 25, cat_invaders_arg_t *)
// #define READ_SPRITE_MATRIX _IOR(CAT_INVADERS_MAGIC, 26, cat_invaders_arg_t *)
// #define READ_UFO_POSITION _IOR(CAT_INVADERS_MAGIC, 27, cat_invaders_arg_t *)
// #define READ_MISC_1 _IOR(CAT_INVADERS_MAGIC, 28, cat_invaders_arg_t *)
// #define READ_SCORE _IOR(CAT_INVADERS_MAGIC, 29, cat_invaders_arg_t *)
// #define READ_BARRIER _IOR(CAT_INVADERS_MAGIC, 30, cat_invaders_arg_t *)
// #define READ_ANIMATION _IOR(CAT_INVADERS_MAGIC, 31, cat_invaders_arg_t *)
// #define READ_BG _IOR(CAT_INVADERS_MAGIC, 32, cat_invaders_arg_t *)
// #define READ_BARK _IOR(CAT_INVADERS_MAGIC, 33, cat_invaders_arg_t *)
// #define READ_MEOW _IOR(CAT_INVADERS_MAGIC, 34, cat_invaders_arg_t *)

#endif
