import os

def parse_mif(file_path):
    with open(file_path, 'r') as file:
        content = file.read()
    lines = content.strip().split("\n")
    data_lines = lines[lines.index("BEGIN") + 1 : lines.index("END;")]
    data = {int(line.split(":")[0].strip(), 16): line.split(":")[1].strip() for line in data_lines if line.strip()}
    return data

def merge_mif_files(folder_path):
    try:
        files = sorted([f for f in os.listdir(folder_path) if f.endswith('.mif')])
        merged_data = {}
        max_address = 0
        file_line_mapping = {}  

        for file in files:
            data = parse_mif(os.path.join(folder_path, file))
            if data:
                start_address = max_address
                for k, v in data.items():
                    new_address = k + max_address
                    merged_data[new_address] = v
                end_address = max_address + max(data.keys())
                max_address += max(data.keys()) + 1
                file_line_mapping[file] = (start_address, end_address)


        # Generate merged MIF content
        merged_mif_content = f"""
        DEPTH =  {max(merged_data.keys()) + 1};
        WIDTH = 16;  # Adjust WIDTH if necessary
        ADDRESS_RADIX = HEX;
        DATA_RADIX = HEX;
        CONTENT
        BEGIN
        """
        for k in sorted(merged_data.keys()):
            data_value = merged_data[k].rstrip(';')  
            merged_mif_content += f"{k:X}: {data_value};\n"
        merged_mif_content += "END;"

        with open('Address_num.txt', 'w') as map_file:
            for file, (start, end) in file_line_mapping.items():
                map_file.write(f"{file}: {start:04X} to {end:04X}\n")

        return merged_mif_content
    
    except Exception as e:
        print(f"An error occurred during merging: {e}")
        return None


# Replace 'your_folder_path' with the path to the folder containing your MIF files
folder_path = '.'
ROM_num = merge_mif_files(folder_path)

# Print or save the merged MIF content
print("generated")
with open('ROM_num.mif', 'w') as file:
    file.write(ROM_num)