import os

def parse_mif(file_path):
    with open(file_path, 'r') as file:
        content = file.read()
    lines = content.strip().split("\n")
    data_lines = lines[lines.index("BEGIN") + 1 : lines.index("END;")]
    data = {int(line.split(":")[0].strip(), 16): line.split(":")[1].strip() for line in data_lines if line.strip()}
    return data

def merge_mif_files(folder_path, file_names):
    try:
        # Ensure only specified files that exist are processed
        files = [f for f in file_names if os.path.isfile(os.path.join(folder_path, f))]
        merged_data = {}
        max_address = 0
        file_line_mapping = {}  

        for file in files:
            data = parse_mif(os.path.join(folder_path, file))
            if data:
                start_address = max_address
                for k, v in data.items():
                    new_address = k + max_address
                    merged_data[new_address] = v
                end_address = max_address + max(data.keys())
                max_address += max(data.keys()) + 1
                file_line_mapping[file] = (start_address, end_address)

        # Generate merged MIF content
        merged_mif_content = "DEPTH = {};\nWIDTH = 8;\nADDRESS_RADIX = HEX;\nDATA_RADIX = HEX;\nCONTENT BEGIN\n".format(max(merged_data.keys()) + 1)
        for k in sorted(merged_data.keys()):
            data_value = merged_data[k].rstrip(';')  
            merged_mif_content += "{:X}: {};\n".format(k, data_value)
        merged_mif_content += "END;"

        with open('Address_barrier.txt', 'w') as map_file:
            for file, (start, end) in file_line_mapping.items():
                map_file.write(f"{file}: {start:04X} to {end:04X}\n")

        return merged_mif_content
    
    except Exception as e:
        print(f"An error occurred during merging: {e}")
        return None

# Path to the folder containing the MIF files and specific files to be merged
folder_path = '.'  # Adjust as necessary
file_names = ['half barrier1.mif', 'half barrier2.mif','half barrier3.mif','half barrier4.mif']
ROM_cat = merge_mif_files(folder_path, file_names)

# Output the merged MIF content
print("Merging completed")
with open('ROM_barrier.mif', 'w') as file:
    file.write(ROM_cat)
