def split_mif(file_path, number_of_parts):
    with open(file_path, 'r') as file:
        lines = file.readlines()

    start_index = lines.index("CONTENT\n") + 2  
    end_index = lines.index("END;\n")

    total_lines = end_index - start_index

    lines_per_part = total_lines // number_of_parts
    remaining_lines = total_lines % number_of_parts

    current_address = 0

    for i in range(number_of_parts):

        if i < remaining_lines:
            part_lines = lines[start_index:start_index + lines_per_part + 1]
            start_index += lines_per_part + 1
        else:
            part_lines = lines[start_index:start_index + lines_per_part]
            start_index += lines_per_part

        depth_line = f"DEPTH = {len(part_lines)};\n"

        for j, line in enumerate(lines):
            if line.startswith("DEPTH ="):
                lines[j] = depth_line
                break

        new_file_lines = lines[:start_index - len(part_lines)] + part_lines + lines[end_index - 1:]
        with open(f"bg_music_part{i+1}.mif", 'w') as part_file:
            part_file.writelines(new_file_lines)

        current_address += len(part_lines)

    with open('address_map_bg_music.txt', 'w') as map_file:
        current_address = 0
        for i in range(number_of_parts):
            part_start_address = current_address
            part_end_address = current_address + lines_per_part - 1 + (1 if i < remaining_lines else 0)
            map_file.write(f"bg_music_part{i+1}.mif: {part_start_address:04X} to {part_end_address:04X}\n")
            current_address = part_end_address + 1

split_mif('background_music.mif', 3)
