/*
 * Avalon memory-mapped peripheral that generates VGA
 *
 * Stephen A. Edwards
 * Columbia University
 */

module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [15:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [4:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n);

   logic [10:0]	   hcount;
   logic [9:0]     vcount;
                                        
   logic [7:0] 	   background_r, background_g, background_b;
	
   vga_counters counters(.clk50(clk), .*);
    logic [15:0] chars_status;
    logic [7:0] cursor;
    
  
    //  logic [7:0] char_bitmap [0:39][0:7];
      logic [7:0] char_0[0:7];
      logic [7:0] char_1[0:7];
      logic [7:0] char_2[0:7];
      logic [7:0] char_3[0:7];
      logic [7:0] char_4[0:7];
      logic [7:0] char_5[0:7];
      logic [7:0] char_6[0:7];
      logic [7:0] char_7[0:7];
      logic [7:0] char_8[0:7];
      logic [7:0] char_9[0:7];
      logic [7:0] char_a[0:7];
      logic [7:0] char_b[0:7];
      logic [7:0] char_c[0:7];
      logic [7:0] char_d[0:7];
      logic [7:0] char_e[0:7];
      logic [7:0] char_f[0:7];
      logic [7:0] char_g[0:7];
      logic [7:0] char_h[0:7];
      logic [7:0] char_i[0:7];
      logic [7:0] char_j[0:7];
      logic [7:0] char_k[0:7];
      logic [7:0] char_l[0:7];
      logic [7:0] char_m[0:7];
      logic [7:0] char_n[0:7];
      logic [7:0] char_o[0:7];
      logic [7:0] char_p[0:7];
      logic [7:0] char_q[0:7];
      logic [7:0] char_r[0:7];
      logic [7:0] char_s[0:7];
      logic [7:0] char_t[0:7];
      logic [7:0] char_u[0:7];
      logic [7:0] char_v[0:7];
      logic [7:0] char_w[0:7];
      logic [7:0] char_x[0:7];
      logic [7:0] char_y[0:7];
      logic [7:0] char_z[0:7];

      logic [7:0] char_mark_1[0:7]; //.
      logic [7:0] char_mark_2[0:7]; //:
      logic [7:0] char_mark_3[0:7]; //-
      logic [7:0] char_mark_4[0:7]; //_
      logic [63:0] iconmap [63:0];
      // Parameters for locate the bitmap
      localparam integer ICON_WIDTH = 64;
      localparam integer ICON_HEIGHT = 64;

      localparam integer ICON_X_START = 640 - ICON_WIDTH - 65;  // Horizontal start at the top right
      localparam integer ICON_Y_START = 60;                 // Vertical start at the top

      logic [7:0] actual_value1;
      logic [7:0] actual_value2;
      logic [7:0] factor_value1;
      logic [7:0] factor_value2;
      logic [7:0] ic1;   
      logic [7:0] ic2;
      logic [7:0] ic3;
      logic [7:0] RGB_R, RGB_G, RGB_B;
      logic [7:0] RGB_R_G, RGB_G_G, RGB_B_G;

      logic [2:0] sign; // 0 represents positive; 1 represents negarive //0bit actual return;1 bit fator; 2 bit initial
     `include "char_bitmaps.sv"
     `include "pic_bitmaps.sv"

     logic [7:0] n_inst;
     logic [2:0] row_inst;
     logic [7:0] bitmap_inst;
    
     numbers number_inst (
    .n(n_inst),
    .row(row_inst),
    .out_bitmap(bitmap_inst));

    initial begin

        {RGB_R, RGB_G, RGB_B} = {8'h1c, 8'hb0, 8'hc7};
        {RGB_R_G, RGB_G_G, RGB_B_G}={8'hA2,8'hCD, 8'h5A};

    end
   always_ff @(posedge clk)
     if (reset) begin
        background_r <= 8'h0;
        background_g <= 8'h0;
        background_b <= 8'h0;
        chars_status <= 16'b0000_0000_0000_0000; // 0 left, 1 right
        actual_value1 <= 8'd0;
        actual_value2 <= 8'd0;
        ic1 <= 8'd0;
        ic2 <= 8'd0;
        ic3 <= 8'd0;
        sign <= 3'h0;
        factor_value1<=8'd0;
        factor_value2<=8'd0;
        cursor <=8'd0;
     end else if (chipselect && write)
       case (address)
	        5'h0: chars_status<= writedata;
          5'h1 : actual_value1 <= writedata[7:0];
          5'h2 : actual_value2 <= writedata[7:0];
          5'h3: ic1 <= writedata[7:0];
          5'h4: ic2 <= writedata[7:0];
          5'h5: ic3 <= writedata[7:0];
          5'h6 : sign <= writedata[2:0];
          5'h11 : factor_value1 <= writedata[7:0];
          5'h12 : factor_value2 <= writedata[7:0];
          5'h13 : cursor <= writedata[7:0];
       endcase

   always_comb begin
      integer icon_x; 
      integer icon_y;
      icon_x = hcount[10:1] - ICON_X_START; // Assign 'icon_x' dynamically based on changing 'hcount'
      icon_y = vcount[9:0] - ICON_Y_START;
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      {n_inst, row_inst} = {8'h0, 2'h0, 8'b00110011};
      if (VGA_BLANK_n)
      begin
      

	if (icon_x >= 0 && icon_x < ICON_WIDTH && icon_y >= 0 && icon_y < ICON_HEIGHT) begin
          if (!iconmap[icon_y][icon_x]) begin 
            {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hd7, 8'h00};  // Golden color  
          end
        end
   //sell/buy/hold

        else if (hcount[10:4] == 8'd32 && vcount[9:3] == 8'd41)
         begin
		if(sign[2]==1'b1)
			begin
			 if(factor_value1==8'b0 && factor_value2== 8'b0)
			   begin  
			      if(char_h[vcount[2:0]][hcount[3:1]])
				      {VGA_R, VGA_G, VGA_B} = {8'hc0, 8'hc0, 8'hc0};
			    end
			  else if(sign[1])
			     begin  
			      if(char_s[vcount[2:0]][hcount[3:1]])
				      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
			     end
			 else
			     begin
				 if(char_b[vcount[2:0]][hcount[3:1]]) 
				 {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hff, 8'h00};
			     end
			 end
	end
        else if (hcount[10:4] == 8'd33 && vcount[9:3] == 8'd41) 
        begin
	    if(sign[2]==1'b1)
		begin
		      if(factor_value1==8'b0 && factor_value2== 8'b0&&sign[2]==1'b1)
		        begin  
		          if(char_o[vcount[2:0]][hcount[3:1]])
		              {VGA_R, VGA_G, VGA_B} = {8'hc0, 8'hc0, 8'hc0};
		        end
		      else if(sign[1])
		          begin
		            if(char_e[vcount[2:0]][hcount[3:1]]) 
		                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
		         end 
		     else
		       begin
		           if(char_u[vcount[2:0]][hcount[3:1]]) 
		               {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hff, 8'h00};
		         end 
        	end
	end
        else if (hcount[10:4] == 8'd34 && vcount[9:3] == 8'd41)
        begin
		if(sign[2]==1'b1)
		begin
		      if(factor_value1==8'b0 && factor_value2== 8'b0&&sign[2]==1'b1)
			begin  
			  if(char_l[vcount[2:0]][hcount[3:1]])
			      {VGA_R, VGA_G, VGA_B} = {8'hc0, 8'hc0, 8'hc0};
			end
		     else if(sign[1])
			 begin  
			  if(char_l[vcount[2:0]][hcount[3:1]]) 
			      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
			 end
		     else
			 begin  
			 if(char_y[vcount[2:0]][hcount[3:1]]) 
			     {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hff, 8'h00};
			 end
		end
	end
        else if (hcount[10:4] == 8'd35 && vcount[9:3] == 8'd41)
        begin
		if(sign[2]==1'b1)
		begin
		    if(factor_value1==8'b0 && factor_value2== 8'b0&&sign[2]==1'b1)
			begin  
			  if(char_d[vcount[2:0]][hcount[3:1]])
			      {VGA_R, VGA_G, VGA_B} = {8'hc0, 8'hc0, 8'hc0};
			end
		     else if(sign[1])
			  if(char_l[vcount[2:0]][hcount[3:1]]) 
			      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
		end
	end

  //features
	else if (hcount[10:4] == 8'd10 && vcount[9:3] == 8'd10)
		begin
		  if(char_f[vcount[2:0]][hcount[3:1]]) //f
		          begin
		                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
		          end
		end
	else if (hcount[10:4] == 8'd11 && vcount[9:3] == 8'd10)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) //e
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
	else if (hcount[10:4] == 8'd12 && vcount[9:3] == 8'd10)  
        begin
          if(char_a[vcount[2:0]][hcount[3:1]]) //a
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
else if (hcount[10:4] == 8'd13 && vcount[9:3] == 8'd10)  
        begin
          if(char_t[vcount[2:0]][hcount[3:1]]) //t
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
else if (hcount[10:4] == 8'd14 && vcount[9:3] == 8'd10)  
        begin
          if(char_u[vcount[2:0]][hcount[3:1]]) //u
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
else if (hcount[10:4] == 8'd15 && vcount[9:3] == 8'd10)  
        begin
          if(char_r[vcount[2:0]][hcount[3:1]]) //r
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
else if (hcount[10:4] == 8'd16 && vcount[9:3] == 8'd10)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) //e
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
else if (hcount[10:4] == 8'd17 && vcount[9:3] == 8'd10)  
        begin
          if(char_s[vcount[2:0]][hcount[3:1]]) //s
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end

        // FACTOR
        else if (hcount[10:4] == 8'd10 && vcount[9:3] == 8'd39) 
          begin
            if(char_f[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd11 && vcount[9:3] == 8'd39) 
          begin
            if(char_a[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd12 && vcount[9:3] == 8'd39) 
          begin
            if(char_c[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd13 && vcount[9:3] == 8'd39) 
          begin
            if(char_t[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd14 && vcount[9:3] == 8'd39) 
          begin
            if(char_o[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd15 && vcount[9:3] == 8'd39) 
          begin
            if(char_r[vcount[2:0]][hcount[3:1]])
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd16 && vcount[9:3] == 8'd39) 
          begin
            if(char_mark_2[vcount[2:0]][hcount[3:1]]) //:
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end

         else if (hcount[10:4] == 8'd17 && vcount[9:3] == 8'd39) 
          begin
            if(sign[1])
              if(char_mark_3[vcount[2:0]][hcount[3:1]])//sign
                  begin
                    {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                  end
          end

        else if (hcount[10:4] == 8'd18 && vcount[9:3] == 8'd39) 
          begin
            if(char_0[vcount[2:0]][hcount[3:1]])//0
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd19 && vcount[9:3] == 8'd39) 
          begin
            if(char_mark_1[vcount[2:0]][hcount[3:1]]) //.
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
          
//option: open
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd12)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd0)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[0] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd12)  
        begin
          if(char_p[vcount[2:0]][hcount[3:1]])
                  begin
                    if (cursor == 8'd0)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[0] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd12)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]])
                  begin
                    if (cursor == 8'd0)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[0] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd12)  
        begin
          if(char_n[vcount[2:0]][hcount[3:1]])
                  begin
                    if (cursor == 8'd0)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[0] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option: high
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd14)  
        begin
          if(char_h[vcount[2:0]][hcount[3:1]]) //option: b
                 begin
                    if (cursor == 8'd1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[1] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd14)  
        begin
          if(char_i[vcount[2:0]][hcount[3:1]]) 
                 begin
                    if (cursor == 8'd1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[1] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd14)  
        begin
          if(char_g[vcount[2:0]][hcount[3:1]]) 
                 begin
                    if (cursor == 8'd1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[1] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd14)  
        begin
          if(char_h[vcount[2:0]][hcount[3:1]]) 
                 begin
                    if (cursor == 8'd1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[1] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option: low
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd16)  
        begin
          if(char_l[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd2)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[2] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd16)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd2)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[2] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd16)  
        begin
          if(char_w[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd2)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[2] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option: close
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd18)  
        begin
          if(char_c[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd3)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[3] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd18)  
        begin
          if(char_l[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd3)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[3] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd18)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd3)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[3] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd18)  
        begin
          if(char_s[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd3)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[3] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd25 && vcount[9:3] == 8'd18)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd3)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[3] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option volume
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd20)  
        begin
          if(char_v[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end

  else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd20)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
   else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd20)  
        begin
          if(char_l[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
    else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd20)  
        begin
          if(char_u[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
    else if (hcount[10:4] == 8'd25 && vcount[9:3] == 8'd20)  
        begin
          if(char_m[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
    else if (hcount[10:4] == 8'd26 && vcount[9:3] == 8'd20)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd4)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[4] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option moment
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd22)  
        begin
          if(char_m[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd22)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd22)  
        begin
          if(char_m[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd22)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd25 && vcount[9:3] == 8'd22)  
        begin
          if(char_n[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd26 && vcount[9:3] == 8'd22)  
        begin
          if(char_t[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd5)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[5] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
    
//option volume factor
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd24)  
        begin
          if(char_v[vcount[2:0]][hcount[3:1]]) //option: c
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd24)  
        begin
          if(char_o[vcount[2:0]][hcount[3:1]]) //option: c
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd24)  
        begin
          if(char_l[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd25 && vcount[9:3] == 8'd24)  
        begin
          if(char_f[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd26 && vcount[9:3] == 8'd24)  
        begin
          if(char_a[vcount[2:0]][hcount[3:1]])
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd27 && vcount[9:3] == 8'd24)  
        begin
          if(char_c[vcount[2:0]][hcount[3:1]])
                  begin
                    if (cursor == 8'd6)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[6] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option RSI
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd26)  
        begin
          if(char_r[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd7)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[7] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
  else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd26)  
        begin
          if(char_s[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd7)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[7] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
  else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd26)  
        begin
          if(char_i[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd7)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[7] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//option MA
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd28)  
        begin
          if(char_m[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd8)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[8] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
  else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd28)  
        begin
          if(char_a[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd8)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[8] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//train
else if (hcount[10:4] == 8'd10 && vcount[9:3] == 8'd30)  
        begin
          if(char_t[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd9)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[9] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd11 && vcount[9:3] == 8'd30)  
        begin
          if(char_r[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd9)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[9] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd12 && vcount[9:3] == 8'd30)  
        begin
          if(char_a[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd9)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[9] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd13 && vcount[9:3] == 8'd30)  
        begin
          if(char_i[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd9)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[9] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd14 && vcount[9:3] == 8'd30)  
        begin
          if(char_n[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd9)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[9] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
//test
else if (hcount[10:4] == 8'd20 && vcount[9:3] == 8'd30)  
        begin
          if(char_t[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd10)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[10] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd30)  
        begin
          if(char_e[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd10)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[10] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd30)  
        begin
          if(char_s[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd10)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[10] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd30)  
        begin
          if(char_t[vcount[2:0]][hcount[3:1]]) 
                  begin
                    if (cursor == 8'd10)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R, RGB_G, RGB_B};
                        end
                    else if(chars_status[10] == 1'b1)
                        begin
                          {VGA_R, VGA_G, VGA_B} = {RGB_R_G, RGB_G_G, RGB_B_G};
                        end
                    else
                        begin
                           {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                        end
                  end
        end
        // IC:
        else if (hcount[10:4] == 8'd10 && vcount[9:3] == 8'd35)  
        begin
          if(char_i[vcount[2:0]][hcount[3:1]]) //I
                  begin
                          {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                  end
        end
        else if (hcount[10:4] == 8'd11 && vcount[9:3] == 8'd35) 
          begin
            if(char_c[vcount[2:0]][hcount[3:1]]) //C
                begin
                       
                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd12 && vcount[9:3] == 8'd35) 
          begin
            if(char_mark_2[vcount[2:0]][hcount[3:1]]) //:
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end

        else if (hcount[10:4] == 8'd14 && vcount[9:3] == 8'd35)
            begin
              if(char_0[vcount[2:0]][hcount[3:1]]) //0
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end
        
        else if (hcount[10:4] == 8'd15 && vcount[9:3] == 8'd35)  
            begin
             if(char_mark_1[vcount[2:0]][hcount[3:1]]) //.
                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end

         else if (hcount[10:4] == 8'd16 && vcount[9:3] == 8'd35)  
            begin
              n_inst = ic1;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end

          else if (hcount[10:4] == 8'd17 && vcount[9:3] == 8'd35)
            begin
              n_inst = ic2;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end
	        else if (hcount[10:4] == 8'd18 && vcount[9:3] == 8'd35)
            begin
              n_inst = ic3;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end

         else if (hcount[10:4] == 8'd27 && vcount[9:3] == 8'd41)  
            begin
              n_inst = actual_value1;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end
        else if (hcount[10:4] == 8'd28 && vcount[9:3] == 8'd41)
            begin
              n_inst = actual_value2;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end 
        else if (hcount[10:4] == 8'd20 && vcount[9:3] == 8'd39)
            begin
              n_inst = factor_value1;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end 
        else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd39)
            begin
              n_inst = factor_value2;
              row_inst = vcount[2:0];
              if (bitmap_inst[hcount[3:1]])
                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
            end 
       
        // ACTUAL RETURN
        else if (hcount[10:4] == 8'd10 && vcount[9:3] == 8'd41) 
          begin
            if(char_a[vcount[2:0]][hcount[3:1]]) //A
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd11 && vcount[9:3] == 8'd41) 
          begin
            if(char_c[vcount[2:0]][hcount[3:1]]) //C
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd12 && vcount[9:3] == 8'd41) 
          begin
            if(char_t[vcount[2:0]][hcount[3:1]]) //T
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd13 && vcount[9:3] == 8'd41) 
          begin
            if(char_u[vcount[2:0]][hcount[3:1]]) //U
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd14 && vcount[9:3] == 8'd41) 
          begin
            if(char_a[vcount[2:0]][hcount[3:1]]) //A
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd15 && vcount[9:3] == 8'd41) 
          begin
            if(char_l[vcount[2:0]][hcount[3:1]]) //L
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        
        else if (hcount[10:4] == 8'd17 && vcount[9:3] == 8'd41) 
          begin
            if(char_r[vcount[2:0]][hcount[3:1]]) //R
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd18 && vcount[9:3] == 8'd41) 
          begin
            if(char_e[vcount[2:0]][hcount[3:1]]) //E
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        
        else if (hcount[10:4] == 8'd19 && vcount[9:3] == 8'd41) 
          begin
            if(char_t[vcount[2:0]][hcount[3:1]]) //T
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd20 && vcount[9:3] == 8'd41) 
          begin
            if(char_u[vcount[2:0]][hcount[3:1]]) //U
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end

        else if (hcount[10:4] == 8'd21 && vcount[9:3] == 8'd41) 
          begin
            if(char_r[vcount[2:0]][hcount[3:1]]) //R
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd22 && vcount[9:3] == 8'd41) 
          begin
            if(char_n[vcount[2:0]][hcount[3:1]]) //N
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end
        else if (hcount[10:4] == 8'd23 && vcount[9:3] == 8'd41) 
          begin
            if(char_mark_2[vcount[2:0]][hcount[3:1]]) //:
                begin
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff}; 
                end
          end

        else if (hcount[10:4] == 8'd24 && vcount[9:3] == 8'd41)  
          begin
            if (sign[0]) // negative - 
                begin
                  if(char_mark_3[vcount[2:0]][hcount[3:1]])
                      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                end
          end
        

        else if (hcount[10:4] == 8'd25 && vcount[9:3] == 8'd41)
              begin  
              if(char_0[vcount[2:0]][hcount[3:1]]) //0
                  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
              end
        
        else if (hcount[10:4] == 8'd26 && vcount[9:3] == 8'd41)  
              if(char_mark_1[vcount[2:0]][hcount[3:1]]) //.
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};

        else
          {VGA_R, VGA_G, VGA_B} =
                  {background_r, background_g, background_b};
      end
   end
	       
endmodule

module numbers(
  input logic [7:0] n,
  input logic[2:0] row,
  output logic [7:0] out_bitmap
);

  logic [7:0] char_0[0:7];
  logic [7:0] char_1[0:7];
  logic [7:0] char_2[0:7];
  logic [7:0] char_3[0:7];
  logic [7:0] char_4[0:7];
  logic [7:0] char_5[0:7];
  logic [7:0] char_6[0:7];
  logic [7:0] char_7[0:7];
  logic [7:0] char_8[0:7];
  logic [7:0] char_9[0:7];
  logic [7:0] bitmap;
`include "number_bitmaps.sv"

always_comb begin
  case(n)
    8'd0:
      bitmap = char_0[row];
    8'd1:
      bitmap = char_1[row];
    8'd2:
      bitmap = char_2[row];
    8'd3:
      bitmap = char_3[row];
    8'd4:
      bitmap = char_4[row];
    8'd5:
      bitmap = char_5[row];
    8'd6:
      bitmap = char_6[row];
    8'd7:
      bitmap = char_7[row];
    8'd8:
      bitmap = char_8[row];
    8'd9:
      bitmap = char_9[row];
    default:
      bitmap = char_0[row];
  endcase
  out_bitmap = {bitmap[0], bitmap[1], bitmap[2], bitmap[3],
            bitmap[4], bitmap[5], bitmap[6], bitmap[7]};
end


endmodule


module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
