// Code your testbench here
// or browse Examples


`timescale 1ns / 1ps

module vga_tb;

    // Inputs to the module
    reg clk;
    reg reset;
    reg [15:0] writedata;
    reg write;
    reg chipselect;
    reg [4:0] address;

    // Outputs from the module
    wire [7:0] VGA_R, VGA_G, VGA_B,
	wire	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
	wire 	   VGA_SYNC_n

    // Instantiate the module under test
    vga_ball vga(
        .clk(clk),
        .reset(reset),
        .writedata(writedata),
        .write(write),
        .chipselect(chipselect),
        .address(address),
        .VGA_R(VGA_R),
        .VGA_G(VGA_G),
        .VGA_B(VGA_B),
        .VGA_CLK(VGA_CLK),
        .VGA_HS(VGA_HS),
        .VGA_VS(VGA_VS),
        .VGA_BLANK_n(VGA_BLANK_n),
        .VGA_SYNC_n(VGA_SYNC_n) 
    );

    // Clock generation
    always #1 clk = ~clk;  // 100MHz clock

    // Test sequence
    initial begin
      $dumpfile("dump.vcd");
      $dumpvars(0, vga_tb);
        // Initialize inputs
        clk = 0;
        reset = 1;  // Assert reset
        writedata = 0;
        write = 0;
        chipselect = 0;
        address = 0;

        // Release reset
        #20 reset = 0;

        // Begin test
        #10;
      perform_write(5'h0, 16'd1);  // Write 100 to register 0 (open price)
      perform_write(5'h1, 16'd0);  // Write 110 to register 1 (high price)
      perform_write(5'h2, 16'd2);   // Write 90 to register 2 (low price)
      perform_write(5'h3, 16'd3);  // Write 105 to register 3 (close price)
      perform_write(5'h4, 16'd4);  // Write 500 to register 4 (volume)
      perform_write(5'h5, 16'd5);  // Write 500 to register 4 (volume)
      perform_write(5'h6, 16'd1);  // Write 500 to register 4 (volume)
      perform_write(5'h11, 16'd1);  // Write 500 to register 4 (volume)
      perform_write(5'h12, 16'd1);  // Write 500 to register 4 (volume)

        #200;  // Wait for operations to conclude
      
      perform_write(5'h0, 16'd2);  // Write 100 to register 0 (open price)
      perform_write(5'h1, 16'd2);  // Write 110 to register 1 (high price)
      perform_write(5'h2, 16'd0);   // Write 90 to register 2 (low price)
      perform_write(5'h3, 16'd1);  // Write 105 to register 3 (close price)
      perform_write(5'h4, 16'd2);  // Write 500 to register 4 (volume)
      perform_write(5'h5, 16'd3);  // Write 500 to register 4 (volume)
      perform_write(5'h6, 16'd0);  // Write 500 to register 4 (volume)
      perform_write(5'h11, 16'd2);  // Write 500 to register 4 (volume)
      perform_write(5'h12, 16'd2);  // Write 500 to register 4 (volume)

        // Additional operations can be added here to further test the module

        #200;  // Wait for operations to conclude
      
        $finish;
    end

    // Task to simplify writing data to the module
    task perform_write;
        input [4:0] addr;
        input [15:0] data;
        begin
            @(posedge clk);
            chipselect = 1;
            write = 1;
            address = addr;
            writedata = data;
            @(posedge clk);
            chipselect = 0;
            write = 0;
        end
    endtask

endmodule

