

`timescale 1ns / 1ps

module calculator_tb;

    // Inputs to the module
    reg clk;
    reg reset;
    reg [15:0] writedata;
    reg write;
  reg read;
    reg chipselect;
  reg [4:0] address;

    // Outputs from the module
  wire [15:0] readdata;

    // Instantiate the module under test
    calculator dut(
        .clk(clk),
        .reset(reset),
        .writedata(writedata),
        .write(write),
      .read(read),
        .chipselect(chipselect),
        .address(address),
      .readdata(readdata)
    );

    // Clock generation
    always #1 clk = ~clk;  // 100MHz clock

    // Test sequence
    initial begin
      $dumpfile("dump.vcd");
      $dumpvars(0, calculator_tb);
        // Initialize inputs
        clk = 0;
        reset = 1;  // Assert reset
        writedata = 0;
        write = 0;
      read = 0;
        chipselect = 0;
        address = 0;

        // Release reset
        #20 reset = 0;

        // Begin test
        #10;
      perform_write(5'h7, 16'd16472);  // Write 100 to register 0 (open price)
      perform_write(5'h8, 16'd16537);  // Write 110 to register 1 (high price)
      perform_write(5'h9, 16'd16362);   // Write 90 to register 2 (low price)
      perform_write(5'ha, 16'd16382);  // Write 105 to register 3 (close price)
      perform_write(5'hb, 16'd3451);  // Write 500 to register 4 (volume)

        // Additional operations can be added here to further test the module
      perform_read(5'hc);

        #200;  // Wait for operations to conclude
      perform_read(5'hc);
      perform_read(5'hd);
      perform_read(5'he);
      perform_read(5'hf);
      perform_read(5'h00010);
      #200
      
      perform_write(5'h7, 16'd16384);  // Write 100 to register 0 (open price)
      perform_write(5'h8, 16'd16444);  // Write 110 to register 1 (high price)
      perform_write(5'h9, 16'd16273);   // Write 90 to register 2 (low price)
      perform_write(5'ha, 16'd16305);  // Write 105 to register 3 (close price)
      perform_write(5'hb, 16'd4950);  // Write 500 to register 4 (volume)

        // Additional operations can be added here to further test the module

        #200;  // Wait for operations to conclude
      perform_read(5'hc);
      perform_read(5'hd);
      perform_read(5'he);
      perform_read(5'hf);
      perform_read(5'h00010);
      #200
      
        $finish;
    end

    // Task to simplify writing data to the module
    task perform_write;
      input [3:0] addr;
        input [15:0] data;
        begin
            @(posedge clk);
            chipselect = 1;
            write = 1;
            address = addr;
            writedata = data;
            @(posedge clk);
            chipselect = 0;
            write = 0;
        end
    endtask
  
  task perform_read;
      input [3:0] addr;
        begin
            @(posedge clk);
            chipselect = 1;
            read = 1;
            address = addr;
            @(posedge clk);
            chipselect = 0;
            read = 0;
        end
    endtask

endmodule

