`include "calculator.sv"
`include "vga_ball.sv"
module pipeline(input logic        clk,
	        input logic 	   reset,
		input logic [15:0]  writedata,
		input logic 	   write, read,
		input 		   chipselect,
		input logic [4:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n,
        output logic [15:0] readdata);

    calculator p_calculator(
        .clk(clk),
        .reset(reset),
        .writedata(writedata),
        .write(write),
        .read(read),
        .chipselect(chipselect),
        .address(address),
        .readdata(readdata)
    );

    vga_ball p_vga(
        .clk(clk),
        .reset(reset),
        .writedata(writedata),
        .write(write),
        .chipselect(chipselect),
        .address(address),
        .VGA_R(VGA_R),
        .VGA_G(VGA_G),
        .VGA_B(VGA_B),
        .VGA_CLK(VGA_CLK),
        .VGA_HS(VGA_HS),
        .VGA_VS(VGA_VS),
        .VGA_BLANK_n(VGA_BLANK_n),
        .VGA_SYNC_n(VGA_SYNC_n)
    );

endmodule
