
`include "global_variables.sv"
`include "./AudioCodecDrivers/audio_driver.sv"


module audio_control( 
       
        // 7-segment LED displays; HEX0 is rightmost
        output logic [6:0]        HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, 
        
        //Audio pin assignments
        //Used because Professor Scott Hauck and Kyle Gagner
        output logic              FPGA_I2C_SCLK,
        inout                     FPGA_I2C_SDAT,
        output logic              AUD_XCK,
        input logic               AUD_ADCLRCK,
        input logic               AUD_DACLRCK,
        input logic               AUD_BCLK,
        input logic               AUD_ADCDAT,
        output logic              AUD_DACDAT,
        
        //Driver IO ports
        input logic               clk,
        input logic               reset,
        input logic [31:0]        writedata,
        input logic               write,
        input logic               read,
        input                     chipselect,
        input logic [15:0]        address,
        output logic [31:0]       readdata,     

        
        
        //filter control
        output logic [15:0]       sink_real,
	input  logic [15:0]       source_real,
	input logic [15 : 0] 	  source_imag
        //button 
	input logic [3:0]  KEY
     
        );
    //Audio Controller
    reg [15:0]      dac_left_in;
    reg [15:0]      dac_right_in;
    wire [15:0]     adc_left_out;
    wire [15:0]     adc_right_out;
    

    // wire advance;
    
    //Device drivers from Altera modified by Professor Scott Hauck and Kyle Gagner in Verilog
    audio_driver aDriver(
        .CLOCK_50(clk), 
        .reset(reset), 
        .dac_left(dac_left_in), 
        .dac_right(dac_right_in), 
        .adc_left(adc_left_out), 
        .adc_right(adc_right_out), 
        .advance(advance), 
        .FPGA_I2C_SCLK(FPGA_I2C_SCLK), 
        .FPGA_I2C_SDAT(FPGA_I2C_SDAT), 
        .AUD_XCK(AUD_XCK), 
        .AUD_DACLRCK(AUD_DACLRCK), 
        .AUD_ADCLRCK(AUD_ADCLRCK), 
        .AUD_BCLK(AUD_BCLK), 
        .AUD_ADCDAT(AUD_ADCDAT), 
        .AUD_DACDAT(AUD_DACDAT)
        );
 
  
  // Debounce variables
wire [15:0] buffer;
    always_comb begin
       // audioInMono = (adc_right_out>>1) + (adc_left_out>>1);
    
         
       buffer=adc_right_out;
   
	
    end

    //Determine when the driver is in the middle of pulling a sample
    //by default dont use the BRAM module
   
    logic [31:0]    driverReading = 31'd0;


	
   
  
    always_ff @(posedge clk) begin : IOcalls
       if (advance)begin
	raw_data <=buffer;
       end
       
        if (chipselect && read) begin
            case (address)
                16'h0000 : begin
			if (raw_data[15] == 0) begin 
				readdata[31:0] <=  32'b0 | raw_data;
                  	end
			else begin 
			readdata[31:0] <=  {16'b1111111111111111, raw_data};
			end
		end
            endcase
	    
        end
      
    end

    wire sampleBeingTaken;
    assign sampleBeingTaken = driverReading[0];
    
    //Map timer(Sample) counter output
    parameter readOutSize = 16'hffff;
    //Sample inputs/Audio passthrough

endmodule

