-- | Abstract syntax tree for the regex plus some helpers.
module REGAST (
  Expr (..)
) where

-- | regex Expressions
-- | empty set 
data Expr
  = Empty_String
  | Empty_Set
  | Literal String
  | Concat Expr Expr
  | Kleene Expr
  | Alternation Expr Expr
  | And Expr Expr
  | Complement Expr
  deriving (Eq, Ord)


-- https://www.haskellforall.com/2020/11/pretty-print-syntax-trees-with-this-one.html
--showReg, showApp, showVar :: Expr -> String
showReg :: Expr -> String

showReg (Empty_String) = "Empty String"
showReg (Empty_Set) = "Empty Set"
showReg (Literal s) = s
showReg (Concat e1 e2) = showReg e1 ++" concated "++ showReg e2
showReg (Kleene e1) = "(" ++ showReg e1 ++")*"
showReg (Alternation e1 e2) = "(" ++ showReg e1 ++ ")|(" ++ showReg e2 ++ ")"
showReg (And e1 e2) = "(" ++ showReg e1 ++ ")&(" ++ showReg e2 ++ ")"
showReg (Complement e1) = "complement (" ++ showReg e1 ++ ")"

--showApp (App e1 e2) = showApp e1 ++ " " ++ showVar e2
--showApp e = showVar e

--showVar (Var i) = i
--showVar e = "(" ++ showReg e ++ ")"

instance Show Expr where
  show e = showReg e



