{-# LANGUAGE OverloadedStrings #-}
{-# OPTIONS_GHC -Wno-unused-top-binds #-}

-- | Parser for the untyped lambda calculus, whose AST is defined in "AST".
module ParseString (parses, tryParse) where

--import qualified AST as A
import qualified REGAST as RA
--import qualified Text.Parsec as P


import Text.Megaparsec (
  MonadParsec (..),
  Parsec,
  errorBundlePretty,
  noneOf,
  oneOf,
  --anyChar,
  runParser,
  some,
  (<?>),
  (<|>),
  between
 )
import Text.Megaparsec.Char( space1 )
import qualified Text.Megaparsec.Char.Lexer as L

import Control.Monad (void)
import Data.Bifunctor (Bifunctor (..))
import Data.Void (Void)

-- * Exposed functions


--myparser :: String -> RA.Expr
--myparser 


-- | Parse a Lambda expression; throw an exception over an error
parses :: String -> RA.Expr
parses = either error id . tryParse

-- | Parse some code 'String' into an 'L.Expr' or an error message.
tryParse :: String -> Either String RA.Expr
tryParse = first errorBundlePretty .
           runParser (pSpace >> pExpr <* eof) "<input>"

{- * Expression parser

Note that Megaparsec allows us to label tokens with 'label' or '(<?>)', which
helps it produce human-readable error messages.
-}


--the fold left and fold right stuff is to handle the parens
--need to get just a token then consume a parens and swap order?



-- | Entry point for parser.
pExpr :: Parser RA.Expr
pExpr = pBody <?> "expression"



--pLam is kleene and complement

pBody :: Parser RA.Expr
pBody = pThingy <|> pApp
 where
  pThingy = do
    str1 <- pFront 
    body <- pBody <?> "complement body"
    --str2 <- pBar
    --bs <- some pIdent <?> "complement body"
   -- let s1 = [ str1 ] in 
    -- let s2 = [ str2 ] in 
    if '*' == str1 then 
      return $ RA.Kleene body 
    else 
     return $ RA.Complement body



{-
pBody = regexp <|> other
    where
        parens2   = between (P.char '(') (P.char ')')
        literal  = RA.Literal <$> P.alphaNum
        kleene   = RA.Kleene <$> restricted <* P.char '*'
            where restricted = literal <|> parens2 regexp
        sequence = foldr1 RA.Concat <$> many1 restricted
            where restricted = P.try kleene <|> parens2 regexp <|> literal
        union    = foldr1 Union <$> sequence `sepBy1` P.char '|'
        regexp   = P.try union <|> sequence
        other = RA.Empty_String

-}




{-
--pLam is kleene and complement
pBody :: Parser RA.Expr
pBody = pComplement  <|> pKleene <|> pApp
 where
  pKleene = do
    pToken "("
    --bs <- some pIdent <?> "kleene binders"
    body <- pBody <?> "kleene body"
    pToken ")"
    let val = pBar in 
     if val == '*' then 
    --body2 <- pBody <?> "kleene body"
       return $ RA.Kleene body 
     else if val == '|' then do 
      body2 <- pBody 
      pToken "("
      return $ RA.Alternation body body2
	 else error "oof"
  pComplement = do
    pToken "¬"
    pToken "("
    body <- pBody <?> "complement body"
    pToken ")"
    --bs <- some pIdent <?> "complement body"
    return $ RA.Complement body
	
-}
{-
  pAlternation = do 
    pToken "("
    --bs1 <- some pIdent <?> "left alternation?"
    bs1 <- pBody <?> "left alternation?"
    pToken ")"
    pToken "|"
    pToken "("
    --bs2 <- some pIdent <?> "right alternation?"
    bs2 <- pBody <?> "right alternation?"
    pToken ")"
    --body <- pBody <?> "alternation body"
    return $ RA.Alternation bs1 bs2 
-}

--pApp here is concat, alternation, and 
-- | Parse juxtaposition as application.
pApp :: Parser RA.Expr
pApp =  foldl1 RA.Concat <$> some pAtom <|> pAlt 
 where 
  pAlt = do
   str1 <- pMid 
   body1 <- pAtom <?> "swapper body1"
   body2 <- pAtom <?> "swapper body2" 
   if '|' == str1 then 
      return $ RA.Alternation body1 body2
   else 
      return $ RA.And body1 body2

--foldl1 RA.Alternation <$> (some pAtom) void(pToken "|") (some pAtom)
-- <|> foldl1 RA.And <$> some pAtom <?> "term and"


--note to self ,'!','^' can be used as empty set and empty string here and checked inside of the literal type?
-- ! for empty string and ^ for empty set 
--pVar here is literal string, emptyset, emptystring
-- | Parse expressions at the highest precedence, including parenthesized terms
pAtom :: Parser RA.Expr
pAtom = pEmptyHandler <|> RA.Literal <$> pVar <|> pParens pExpr 
 where
  pVar = pIdent <?> "variable"
  pEmptyHandler = do 
   str1 <- pEmpty
   if '!' == str1 then 
    return $ RA.Empty_String
   else 
    return $ RA.Empty_Set
{-  pAlt = do
   body1 <- pAtom <?> "swapper body1"
   str1 <- pMid 
   body2 <- pAtom <?> "swapper body2" 
   if '|' == str1 then 
      return $ RA.Alternation body1 body2
   else 
      return $ RA.And body1 body2
-}




{-
-- | Parse expressions at the lowest level of precedence, just a token
pBody :: Parser RA.Expr
pBody = RA.Literal <$> pIdent <|> pAlternation
 where 
 pAlternation =  do 
    pToken "("
    bs1 <- some pExpr <?> "left alternation?"
    pToken ")"
    pToken "+"
    pToken "("
    bs2 <- some pExpr <?> "right alternation?"
    pToken ")"
    return $ foldl1 RA.Alternation bs1 bs2
  
  
  
-}
  
  
  
{-
pAlternation :: Parser RA.Expr
pAlternation =  do 
    pToken "("
    bs1 <- some pExpr <?> "left alternation?"
    pToken ")"
    pToken "+"
    pToken "("
    bs2 <- some pExpr <?> "right alternation?"
    pToken ")"
    return $ foldr RA.Alternation bs1 bs2
-}
{-
pKleene <|> pConcat <|> pAlternation <|> pEmptySet <|> pEmptyString 
 
-- | <|> pToken 

pKleene :: Parser RA.Expr
pKleene = 
    pToken "("
    bs <- some pExpr <?> "kleene center?"
    pToken ")*"
    return $ foldr RA.Kleene bs

pComplement :: Parser RA.Expr
pComplement =
    pToken "¬"
    pToken "("
    bs1 <- some pIdent <?> "complement?"
    pToken ")"
    return $ foldr RA.Complement bs1




pConcat :: Parser RA.Expr
pConcat =
    pToken "("
    bs1 <- some pIdent <?> "left concat?"
    pToken ")"
    pToken "("
    bs2 <- some pIdent <?> "right concat?"
    pToken ")"
    return $ foldr RA.Concat bs1 bs2

-}


{-
pAnd :: Parser RA.Expr
pAnd = 
    pToken "("
    bs1 <- some pIdent <?> "left and?"
    pToken ")"
    pToken "&"
    pToken "("
    bs2 <- some pIdent <?> "right and?"
    pToken ")"
    return $ foldr RA.And bs1 bs2

-}
-- | Parse high precedence empty stuff
--pEmpty_String :: Parser RA.Expr
--pEmpty_String = RA.Empty_String <$> pEmptyString 


--pEmpty_Set :: Parser RA.Expr
--pEmpty_Set = RA.Empty_Set <$> pEmptySet 

 







-- * Megaparsec boilerplate and helpers

-- | Parsing monad.
type Parser = Parsec Void String


-- | Parse the empty string
--pEmptyString :: Parser String
--pEmptyString = pToken "!"

-- | Parse the empty set 
--pEmptySet :: Parser String
--pEmptySet = pToken "^"

-- | Parse an identifier, possible surrounded by spaces
pIdent :: Parser String
pIdent = L.lexeme pSpace (some $ noneOf ['\\','.','(',')',' ','\n','\r','\t','-','+','*','|','&','¬','!','^'])

pEmpty :: Parser Char
pEmpty = L.lexeme pSpace (oneOf ['!','^'])

pFront :: Parser Char
pFront = L.lexeme pSpace (oneOf ['*', '¬'])
--pBar = L.lexeme pSpace anyChar

--TODO: you have two logical ORs here
pMid :: Parser Char
pMid = L.lexeme pSpace (oneOf ['|', '+','&'])


-- | Consume a token defined by a string, possibly surrounded by spaces
pToken :: String -> Parser ()
pToken = void . L.symbol pSpace
--pToken = L.symbol pSpace

-- | Parse some element surrounded by parentheses.
pParens :: Parser a -> Parser a
pParens = between (pToken "(") (pToken ")")

-- | Consumes whitespace and comments.
pSpace :: Parser ()
pSpace = label "whitespace" $ L.space
    space1
    (L.skipLineComment "--")
    (L.skipBlockCommentNested "{-" "-}")
