module HWREG
  ( 
  v_r
  , get_deriv
  , simplify_regex
  , check_is_string_language
  , check_against_library
  --, check_is_string_language_print_steps
  --, repeatedly 
  --, printnormal
 -- , myfoldl
  , check_is_string_language_print_steps
  , equivalence_regex
  , equivalence_regex_checker
  --fv
  -- , subst
  -- , normalstep
  -- , pickFresh
  -- , repeatedly 
  -- , printnormal
 -- , v_r
  ) where

import REGAST
--import qualified Data.Set as Set
import ParseString (parses)
import Text.Regex.TDFA


-- | v(r) to check if nullable 


v_r :: Expr -> Expr
v_r  (Empty_String) = Empty_String
v_r (Empty_Set) = Empty_Set
v_r (Literal _) = Empty_Set
v_r (Concat e1 e2) = And (v_r e1) (v_r e2)
v_r (Alternation e1 e2) = Alternation (v_r e1) (v_r e2)
v_r (Kleene _) = Empty_String
v_r (And e1 e2) = And (v_r e1) (v_r e2)
v_r (Complement e1) = let val = (v_r e1) in 
 case val of 
          Empty_Set -> Empty_String
          Empty_String -> Empty_Set
          e2 -> e2






get_deriv :: Char -> Expr -> Expr

get_deriv ('!') e1 = e1
get_deriv (_) (Empty_String) = Empty_Set
get_deriv (c) (Literal s1) = if (length s1 == 1) && ( s1 == [c]) then Empty_String else if (length s1 == 1) && (s1 /= [c]) then Empty_Set else Empty_Set
 --the string is long so we need to iterate over it like it is concatentation
 -- to be clear: we want to iterate over the string and return a list of Expr where each is Literal String but the string has only length 1 
 -- then once we have that list of Expr we need to call
 -- wait what if we just always passed in parses that are seperated by spaces? lol that works
 --ghci> parses "(*a) b c"
-- (a)* concated b concated c
 --	foldl () 
get_deriv (_) (Empty_Set) = Empty_Set
get_deriv (c) (Concat e1 e2) = Alternation (Concat (get_deriv c e1) e2) ( Concat (v_r e1)  (get_deriv c e2)  )
get_deriv (c) (Kleene e1) = Concat (get_deriv c e1) (Kleene e1)
get_deriv (c) (Alternation e1 e2) = Alternation (get_deriv c e1) (get_deriv c e2)
get_deriv (c) (And e1 e2) = And (get_deriv c e1) (get_deriv c e2)
get_deriv (c) (Complement e1) = Complement (get_deriv c e1)

--TODO: extend this to a string? 

--TODO: make a simplify function that handles how regex happens to behave according to Sipser



-- take in a v_r output and simplify it to either Empty string or Empty set
{-
simplifiy_regex :: Expr -> Expr 

simplifiy_regex (And e1 e2) = let e_out_1 = simplifiy_regex e1 in let e_out_2 = simplifiy_regex e2 in 
 case (e_out_1, e_out_2) of 
  (Empty_String, Empty_String) -> Empty_String 
  _ -> Empty_Set
simplifiy_regex (Alternation e1 e2) = let e_out_1 = simplifiy_regex e1 in let e_out_2 = simplifiy_regex e2 in 
 case (e_out_1, e_out_2) of 
  (Empty_String, _) -> Empty_String
  (_, Empty_String) -> Empty_String
  _ -> Empty_Set
simplifiy_regex (e1) = e1

-}



-- takes in an expression output from v_r and then decides what it should be simplified
simplify_regex :: Expr -> Expr 

simplify_regex (And e1 e2) = let e_out_1 = simplify_regex e1 in let e_out_2 = simplify_regex e2 in 
 case (e_out_1, e_out_2) of 
  (Empty_String, Empty_String) -> Empty_String 
  _ -> Empty_Set
simplify_regex (Alternation e1 e2) = let e_out_1 = simplify_regex e1 in let e_out_2 = simplify_regex e2 in 
 case (e_out_1, e_out_2) of 
  (Empty_String, _) -> Empty_String
  (_, Empty_String) -> Empty_String
  _ -> Empty_Set
simplify_regex (e1) = e1





-- take in a string to check and a regex to use as the language and return if it is in the language
check_is_string_language :: String -> Expr -> Bool
check_is_string_language s1 e1 = let v_output = simplify_regex (v_r (foldl (flip get_deriv) (e1) (s1) ) )
  in case v_output of 
   Empty_String -> True
   _ -> False
--last_deriv foldl get_deriv c1...cn e1  s1
--take in the string take each character in order and get the derivative then take the derivative of that derivative 
--foldl:: (a -> b -> a) -> a -> [b] -> a
--foldl get_deriv e1 s1 



-- take in 
-- a string to match with 
--and a regex of my version as a string 
--and a string of Text-Regex-TDFA version 
--and return if they are the same
check_against_library :: String -> String -> String -> Bool

check_against_library s_to_check s_our_regex_to_parse s_their_regex_to_parse = let ourans = check_is_string_language s_to_check (parses s_our_regex_to_parse) 
 in let theirans = s_to_check =~ s_their_regex_to_parse :: Bool in ourans == theirans




{-

-- | Repeatedly apply a function to transform a value, returning the list
-- of steps it took.  The result list starts with the given initial value
repeatedly :: (a -> Maybe a) -> a -> [a]
repeatedly f = repeatedly'
  where repeatedly' x = x : case f x of Nothing -> []
                                        Just y -> repeatedly' y

-- | Print out the series of derivatives steps
printnormal :: String -> IO ()
printnormal = mapM_ print . repeatedly . (flip get_deriv) . parses .
-}
--maybe rewrite this with Prelude> foldl (\x y -> concat ["(",x,"+",y,")"]) "0" (map show [1..13]) in https://wiki.haskell.org/Fold syntax
--foldl (\x y -> concat ["(",x," matching on ",y,")"])

{-
check_is_string_language_print_steps :: String -> Expr -> Bool
check_is_string_language_print_steps s1 e1 = let v_output = simplify_regex (v_r (myfoldl (flip get_deriv) (e1) (map show s1) ) )
  in case v_output of 
   Empty_String -> True
   _ -> False


--what if instead i turned the char array into an array of arrays of char in increasing order? inits function
myfoldl :: (b -> a -> b) -> b -> [a] -> b
myfoldl f acc [] = acc
myfoldl f acc (x:xs) = let val = (f acc x) in do 
 print (show val)
 return $ myfoldl f val xs

-}
--inits 

--take in a string and an expression and print out the derivatives steps it takes it also will print the first step of just the regex parsed
-- if the last derivative can simplify to the empty string then the string is in the language
--this does not work on the empty string as that has no steps
check_is_string_language_print_steps :: String -> Expr -> IO ()
check_is_string_language_print_steps s1 e1 =  print (map show (scanl (flip get_deriv) (e1) (s1)))
 
 
 
 
 
-- RE equivalence converter
--uses weaker notion of Expr equivalence to turn it into a simplified form that is mostly equivalent
equivalence_regex :: Expr -> Expr
equivalence_regex (And e3 e4) = let leftbranch = equivalence_regex e3 in let rightbranch = equivalence_regex e4 in 
 case (leftbranch,rightbranch) of 
 --(e1, e1) -> leftbranch
 (Empty_Set, _) -> Empty_Set
 (_, Empty_Set) -> Empty_Set
 (Complement e1, e2) -> if e1 == Empty_Set then e2 else And (Complement e1) (e2)
 (e1, Complement e2) -> if e2 == Empty_Set then e1 else And (e1) (Complement e2)
 ((And e1 e2), e5) -> And e1 (And e2 e5)
 (e1, e2) -> if e1 == e2 then e1 else And e1 e2
 
equivalence_regex (Alternation e3 e4) = let leftbranch = equivalence_regex e3 in let rightbranch = equivalence_regex e4 in 
 case (leftbranch,rightbranch) of 
 --(e1, e1) -> leftbranch
 (Empty_Set, e2) -> e2
 (e2, Empty_Set) -> e2
 (Complement e1, e2) -> if e1 == Empty_Set then Complement Empty_Set else Alternation (Complement e1) (e2)
 (e1, Complement e2) -> if e2 == Empty_Set then Complement Empty_Set else Alternation (e1) (Complement e2)
 ((Alternation e1 e2), e5) -> Alternation e1 (Alternation e2 e5)
 (e1, e2) -> if e1 == e2 then e1 else Alternation e1 e2
 
equivalence_regex (Concat e3 e4) = let leftbranch = equivalence_regex e3 in let rightbranch = equivalence_regex e4 in 
 case (leftbranch,rightbranch) of 
 (Empty_Set, _) -> Empty_Set
 (_, Empty_Set) -> Empty_Set
 (Empty_String, e2) -> e2
 (e2, Empty_String) -> e2
 ((Concat e1 e2), e5) -> Concat e1 (Concat e2 e5)
 (e1, e2) -> Concat e1 e2
 
equivalence_regex (Kleene e3) = let branch = equivalence_regex e3 in 
 case branch of 
 (Kleene e1) -> Kleene e1
 (Empty_String) -> Empty_String
 (Empty_Set) -> Empty_String
 (e1) -> Kleene e1
 
equivalence_regex (Complement e3) = let branch = equivalence_regex e3 in 
 case branch of 
 (Complement e1) -> e1
 e2 -> Complement e2
 
equivalence_regex e1 = e1 
 
 
 
 
 
 
 
--check if two regex are equivalent using the simplification rules that are not in the equivalence_regex
--needs inputs that have been passed through equivalence_regex already
equivalence_regex_checker :: Expr -> Expr -> Bool
--equivalence_regex_checker e1 e2 = let left = equivalence_regex e1 in let right = equivalence_regex e2 in 
equivalence_regex_checker Empty_Set Empty_Set = True
equivalence_regex_checker Empty_String Empty_String = True
--check if they are the same one level down
{-
  = Empty_String
  | Empty_Set
  | Literal String
  | Concat Expr Expr
  | Kleene Expr
  | Alternation Expr Expr
  | And Expr Expr
  | Complement Expr
  -}
equivalence_regex_checker (And e1 e2) (And e3 e4) = let val13 = equivalence_regex_checker e1 e3 in let val14 = equivalence_regex_checker e1 e4 in let val23 = equivalence_regex_checker e2 e3 in let val24 = equivalence_regex_checker e2 e4 in 
  if (val13 && val24) || (val14 && val23) then True else False

equivalence_regex_checker (Alternation e1 e2) (Alternation e3 e4) = let val13 = equivalence_regex_checker e1 e3 in let val14 = equivalence_regex_checker e1 e4 in let val23 = equivalence_regex_checker e2 e3 in let val24 = equivalence_regex_checker e2 e4 in 
  if (val13 && val24) || (val14 && val23) then True else False
  
equivalence_regex_checker (Kleene e1) (Kleene e2) = equivalence_regex_checker e1 e2
equivalence_regex_checker (Complement e1) (Complement e2) = equivalence_regex_checker e1 e2
equivalence_regex_checker (Concat e1 e2) (Concat e3 e4) = let val13 = equivalence_regex_checker e1 e3 in let val24 = equivalence_regex_checker e2 e4 in val13 && val24
equivalence_regex_checker (Literal s1) (Literal s2) = s1 == s2

equivalence_regex_checker _ _ = False
 
 
 
 
 
 
 
 
 

{-





-- | Return the free variables in an expression
fv :: Expr -> Set.Set String
--fv _ = Set.singleton "UNIMPLEMENTED" -- Replace with your solution to problem 1
fv (App e1 e2) = Set.union (fv e1) (fv e2) 
fv (Var s1) = Set.singleton s1 
fv (Lam s2 e3) = Set.delete s2 (fv e3)
--slide 16 Lambda Calc
--https://haskell-containers.readthedocs.io/en/latest/set.html
--https://hackage.haskell.org/package/containers-0.6.7/docs/Data-Set.html#t:Set


-- | Substitute n for x in e, avoiding name capture
--    subst n x e     e[x := n]
subst :: Expr -> String -> Expr -> Expr
--subst _ _ _ = Var "UNIMPLEMENTED" -- Replace with your solution to problem 2
--subst e3 x1 (Var s4) = which s4
-- | s4 == x1 = e3
-- | _ = Var s4
--subst e3 s4 (Var s4) = e3
--subst e3 x1 (Var s4) = Var s4
subst e3 x1 (Var s4) = if s4 == x1 then e3 else Var s4
subst e6 x2 (App e4 e5) = App (subst e6 x2 e4) (subst e6 x2 e5)
subst e7 s5 (Lam s6 e8) = if s5 == s6 then Lam s6 e8 else 
      if not (Set.member s6 (fv e7)) then Lam s6 (subst e7 s5 e8)
      else --Complicated case
      let newvar = pickFresh (Set.union (fv e7) (fv e8)) s6 in 
      let newexpr = Lam newvar (subst (Var newvar) s6 e8) in 
      (subst e7 s5 newexpr)
--https://cheatsheet.codeslower.com/CheatSheet.pdf
--http://zvon.org/other/haskell/Outputprelude/not_f.html



-- | Take a single step in normal order reduction or return Nothing
normalstep :: Expr -> Maybe Expr
--normalstep _ = Just (Var "UNIMPLEMENTED") -- Replace with your solution to problem 3
--slide 77 of Lambda Calc
--maybe write out the beta reduction and other pieces of this in their own seperate areas 
--then try to inforce an order and rules?

--order supposed to be beta func arg
--just a variable
normalstep (Var s7) = Nothing

--beta rule?
normalstep (App (Lam s9 e10) e11) = Just (subst e11 s9 e10)
--func and arg rule?
{-
normalstep (App e12 e13) = 
    let leftbranch = (normalstep e12) in 
    if leftbranch == Nothing then 
       let rightbranch = (normalstep e13) in 
        if rightbranch == Nothing then
            Nothing
        else 
          Just (App e12 (fromJust rightbranch))
    else 
	    Just (App leftbranch e13)

-}

normalstep (App e12 e13) = 
    let leftbranch = (normalstep e12) in 
        case leftbranch of 
          Nothing -> let rightbranch = (normalstep e13) in 
             case rightbranch of
               Nothing -> Nothing
               Just someotherexpr -> Just (App e12 someotherexpr)
          Just someexpr -> Just (App someexpr e13)
--https://rosettacode.org/wiki/String_comparison#Haskell
--https://stackoverflow.com/questions/10755852/how-to-concat-two-io-strings-in-haskell
--https://stackoverflow.com/questions/4131552/haskell-check-if-integer-or-check-type-of-variable#:~:text=If%20you%20are%20using%20an,the%20type%20of%20an%20expression.
--https://stackoverflow.com/questions/24718543/couldnt-match-expected-type-maybe-string-int-string-with-actual-type-c
--https://stackoverflow.com/questions/18808258/what-does-the-just-syntax-mean-in-haskell
--https://stackoverflow.com/questions/23815020/fromjust-vs-just-in-haskell
--https://www.diffchecker.com/text-compare/



{-
--body rule? what if the body is nothing?
normalstep (Lam s8 e9) =  let innerbody = (normalstep e9) in
    if innerbody == Nothing then 
        Nothing
    else 
      Just (Lam s8 (fromJust innerbody))
-}

--body rule? what if the body is nothing?
normalstep (Lam s8 e9) =  let innerbody = (normalstep e9) in
    case innerbody of
      Nothing -> Nothing
      Just somethirdexpr -> Just (Lam s8 somethirdexpr)





-- | Return a "fresh" name not already in the set.
-- Tries x' then x'', etc.
pickFresh :: Set.Set String -> String -> String
pickFresh s = pickFresh'
  where pickFresh' n | n `Set.notMember` s = n
        pickFresh' n                       = pickFresh' $ n ++ "'"
               
-- | Repeatedly apply a function to transform a value, returning the list
-- of steps it took.  The result list starts with the given initial value
repeatedly :: (a -> Maybe a) -> a -> [a]
repeatedly f = repeatedly'
  where repeatedly' x = x : case f x of Nothing -> []
                                        Just y -> repeatedly' y

-- | Print out the series of normal order reduction steps
printnormal :: String -> IO ()
printnormal = mapM_ print . repeatedly normalstep . parse



-}