module HWDFA
  ( 
 -- check_is_string_language
 -- , check_against_library
 -- , check_is_string_language_print_steps
  is_string_dfa_accepted,
  get_next_state,
  is_string_dfa_accepted_print_steps,
  string_to_dfa
  ) where

import REGAST
import DFAAST
--import qualified Data.Set as Set
import ParseString (parses)
--import Text.Regex.TDFA
import qualified Data.Set as Set
import qualified Data.Map as Map

-- take in a dfa and a string to check against and output whether the dfa accepts that string
is_string_dfa_accepted :: DFAExpr -> String -> Bool
--fold over the string and keep track of the state with an accumulator 
--when finished check if that state is in the accept states
--TODO: add checker to make sure that the string is within the alphabet?
is_string_dfa_accepted (DFABuilder _ q_0 big_f_0 our_lambda _) str_to_check = 
 let end_state = foldl (get_next_state our_lambda) q_0 str_to_check 
  in case end_state of 
     Literal "NOT IN ALPHABET/TRANSITION NOT AVAILABLE" -> False
     a_real_state -> Set.member a_real_state big_f_0
 
--takes in the transition function and a character and a current state and returns the next state or Literal "NOT IN ALPHABET/TRANSITION NOT AVAILABLE" if there is none
get_next_state :: Lambda -> Expr  -> Char ->  Expr

get_next_state our_lambda curr_state c = let maybe_next_state = Map.lookup (curr_state, c) our_lambda
 in case maybe_next_state of 
  Nothing -> Literal "NOT IN ALPHABET/TRANSITION NOT AVAILABLE" 
  (Just e_val) -> e_val




--print out the steps to what your doing and whether you accept at the end
is_string_dfa_accepted_print_steps :: String -> DFAExpr -> IO ()
is_string_dfa_accepted_print_steps str_to_check (DFABuilder _ q_0 big_f_0 our_lambda _) = --let str_DFA = show (DFABuilder big_q_0 q_0 big_f_0 our_lambda alphabet) in 
{- print ( [str_DFA] ++ 
   map show (
       scanl (get_next_state our_lambda) (q_0) (str_to_check)
    ) 
 )


 mapM_ print ( [str_DFA] ++ 
   map show (
       scanl (get_next_state our_lambda) (q_0) (str_to_check)
    ) 
 )


-}
 let states = scanl (get_next_state our_lambda) (q_0) (str_to_check) in 
  let is_accept = Set.member (last states) big_f_0 in 
   let e_end = if is_accept then Literal "Accepted" else Literal "Rejected" in 
    let states2 = states ++ [e_end] in 
     mapM_ print (
       map show (
           states2
        )
     )





string_to_dfa :: String -> DFAExpr
string_to_dfa s1 = mkDFA (parses s1)

{-




-- take in a string to check and a regex to use as the language and return if it is in the language
check_is_string_language :: String -> Expr -> Bool
check_is_string_language s1 e1 = let v_output = simplify_regex (v_r (foldl (flip get_deriv) (e1) (s1) ) )
  in case v_output of 
   Empty_String -> True
   _ -> False



-- take in 
-- a string to match with 
--and a regex of my version as a string 
--and a string of Text-Regex-TDFA version 
--and return if they are the same
check_against_library :: String -> String -> String -> Bool

check_against_library s_to_check s_our_regex_to_parse s_their_regex_to_parse = let ourans = check_is_string_language s_to_check (parses s_our_regex_to_parse) 
 in let theirans = s_to_check =~ s_their_regex_to_parse :: Bool in ourans == theirans



--take in a string and an expression and print out the derivatives steps it takes it also will print the first step of just the regex parsed
-- if the last derivative can simplify to the empty string then the string is in the language
--this does not work on the empty string as that has no steps
check_is_string_language_print_steps :: String -> Expr -> IO ()
check_is_string_language_print_steps s1 e1 =  print (map show (scanl (flip get_deriv) (e1) (s1)))
 
-}
 
 
 

 
 
