module HW
  ( fv
  , subst
  , normalstep
  , pickFresh
  , repeatedly 
  , printnormal
  ) where

import AST
import qualified Data.Set as Set
import Parse (parse)

-- | Return the free variables in an expression
fv :: Expr -> Set.Set String
--fv _ = Set.singleton "UNIMPLEMENTED" -- Replace with your solution to problem 1
fv (App e1 e2) = Set.union (fv e1) (fv e2) 
fv (Var s1) = Set.singleton s1 
fv (Lam s2 e3) = Set.delete s2 (fv e3)
--slide 16 Lambda Calc
--https://haskell-containers.readthedocs.io/en/latest/set.html
--https://hackage.haskell.org/package/containers-0.6.7/docs/Data-Set.html#t:Set


-- | Substitute n for x in e, avoiding name capture
--    subst n x e     e[x := n]
subst :: Expr -> String -> Expr -> Expr
--subst _ _ _ = Var "UNIMPLEMENTED" -- Replace with your solution to problem 2
--subst e3 x1 (Var s4) = which s4
-- | s4 == x1 = e3
-- | _ = Var s4
--subst e3 s4 (Var s4) = e3
--subst e3 x1 (Var s4) = Var s4
subst e3 x1 (Var s4) = if s4 == x1 then e3 else Var s4
subst e6 x2 (App e4 e5) = App (subst e6 x2 e4) (subst e6 x2 e5)
subst e7 s5 (Lam s6 e8) = if s5 == s6 then Lam s6 e8 else 
      if not (Set.member s6 (fv e7)) then Lam s6 (subst e7 s5 e8)
      else --Complicated case
      let newvar = pickFresh (Set.union (fv e7) (fv e8)) s6 in 
      let newexpr = Lam newvar (subst (Var newvar) s6 e8) in 
      (subst e7 s5 newexpr)
--https://cheatsheet.codeslower.com/CheatSheet.pdf
--http://zvon.org/other/haskell/Outputprelude/not_f.html



-- | Take a single step in normal order reduction or return Nothing
normalstep :: Expr -> Maybe Expr
--normalstep _ = Just (Var "UNIMPLEMENTED") -- Replace with your solution to problem 3
--slide 77 of Lambda Calc
--maybe write out the beta reduction and other pieces of this in their own seperate areas 
--then try to inforce an order and rules?

--order supposed to be beta func arg
--just a variable
--normalstep (Var s7) = Nothing
normalstep (Var _) = Nothing
--beta rule?
normalstep (App (Lam s9 e10) e11) = Just (subst e11 s9 e10)
--func and arg rule?
{-
normalstep (App e12 e13) = 
    let leftbranch = (normalstep e12) in 
    if leftbranch == Nothing then 
       let rightbranch = (normalstep e13) in 
        if rightbranch == Nothing then
            Nothing
        else 
          Just (App e12 (fromJust rightbranch))
    else 
	    Just (App leftbranch e13)

-}

normalstep (App e12 e13) = 
    let leftbranch = (normalstep e12) in 
        case leftbranch of 
          Nothing -> let rightbranch = (normalstep e13) in 
             case rightbranch of
               Nothing -> Nothing
               Just someotherexpr -> Just (App e12 someotherexpr)
          Just someexpr -> Just (App someexpr e13)
--https://rosettacode.org/wiki/String_comparison#Haskell
--https://stackoverflow.com/questions/10755852/how-to-concat-two-io-strings-in-haskell
--https://stackoverflow.com/questions/4131552/haskell-check-if-integer-or-check-type-of-variable#:~:text=If%20you%20are%20using%20an,the%20type%20of%20an%20expression.
--https://stackoverflow.com/questions/24718543/couldnt-match-expected-type-maybe-string-int-string-with-actual-type-c
--https://stackoverflow.com/questions/18808258/what-does-the-just-syntax-mean-in-haskell
--https://stackoverflow.com/questions/23815020/fromjust-vs-just-in-haskell
--https://www.diffchecker.com/text-compare/



{-
--body rule? what if the body is nothing?
normalstep (Lam s8 e9) =  let innerbody = (normalstep e9) in
    if innerbody == Nothing then 
        Nothing
    else 
      Just (Lam s8 (fromJust innerbody))
-}

--body rule? what if the body is nothing?
normalstep (Lam s8 e9) =  let innerbody = (normalstep e9) in
    case innerbody of
      Nothing -> Nothing
      Just somethirdexpr -> Just (Lam s8 somethirdexpr)





-- | Return a "fresh" name not already in the set.
-- Tries x' then x'', etc.
pickFresh :: Set.Set String -> String -> String
pickFresh s = pickFresh'
  where pickFresh' n | n `Set.notMember` s = n
        pickFresh' n                       = pickFresh' $ n ++ "'"
               
-- | Repeatedly apply a function to transform a value, returning the list
-- of steps it took.  The result list starts with the given initial value
repeatedly :: (a -> Maybe a) -> a -> [a]
repeatedly f = repeatedly'
  where repeatedly' x = x : case f x of Nothing -> []
                                        Just y -> repeatedly' y

-- | Print out the series of normal order reduction steps
printnormal :: String -> IO ()
printnormal = mapM_ print . repeatedly normalstep . parse
