-- | Abstract syntax tree for the dfa plus some helpers.

module DFAAST (
   DFAExpr (..),
   Q,
 --  Q_0,
  -- F_0,
   Lambda,
   Epsilon,
   handleList,
   goto,
   mkDFA,
   showDFA
) where

import qualified Data.Set as Set
import qualified Data.Map as Map
import REGAST
import HWREG


--- maybe need to just create one data and just say take in a map or a Set.Set Expr and just have one constructor that takes in like 4 different DFA at once?

-- | dfa pieces
--import Data.HashMap (HashMap, (!))
--import qualified Data.HashMap as HM


data DFAExpr 
  --  =  Q Q_0 F_0 Lambda Epsilon
    = DFABuilder Q Expr (Set.Set Expr) Lambda Epsilon
    deriving (Eq, Ord)


type Q = Set.Set Expr
--type Q_0 = Expr
--type F_0 = Set.Set Expr
type Lambda     =  Map.Map (Expr, Char) (Expr)
type Epsilon = [Char]






{-
type Lambda     =  Map.Map ((Set.Set Expr), Char) (Set.Set Expr)
type Q = (Set.Set (Set.Set Expr))
type Epsilon = (Set.Set Char)
type Q_0 = (Set.Set Expr)
type F_0 = (Set.Set (Set.Set Expr))
-}

{-
data Lambda
--transition function to map a state and a letter to a state
   = Lam :: Map ((Set.Set Expr), Char) (Set.Set Expr)
   deriving (Eq, Ord)
data Q
--Q is a set of states but each state is a set of brzowskis?
   = States :: (Set.Set (Set.Set Expr))
   deriving (Eq, Ord)
data Epsi
-- set of chars in the alphabet
   = Eps :: (Set.Set Char)
   deriving (Eq, Ord)
data Q_0
--start state
   = Q_o :: (Set.Set Expr)
   deriving (Eq, Ord)
data F
--set of accept states
   = F_0 :: (Set.Set (Set.Set Expr)) 
   deriving (Eq, Ord)


-}

 --in let our_q_prime_set = Set.singleton q_prime 
  -- we need to still iterate over the set and check ourselves with equivalence_regex_checker function, maybe just store a set of lists?
  --but then you would need to map a list to a value?
  -- maybe we store the Q as a Set of lists of expr but then Lambda maps only a hash or something to the Set expr?
  -- this does not seem to make sense???? 
  -- if its equivalent do we really need to store it??
  -- why not just store the Expr that we found first?




-- function to iterate over a list and return the index of the element that is the equivalence_regex_checker equivalent or -1 if not found

--function to iterate over a list and return the Expr that matches using the checking function if any
handleList :: [Expr] -> Expr -> Expr
--handleList listy e1 = let (spot, val, flag) = foldl (\ (val) (count, match_to_check, foundflag) -> if foundflag then (count, match_to_check, foundflag) else if equivalence_regex_checker val match_to_check then (count, match_to_check, True) else ((count+1), match_to_check, foundflag)) (0,e1, False) listy
-- in if flag then spot else -1
handleList listy e1 = foldl (\ (accum) (val) -> if equivalence_regex_checker val accum then val else accum) e1 listy


-- implementation of the algorithm for DFA construction
goto ::  Expr -> (Q, Lambda) ->  Char -> (Q, Lambda)
goto q1 (q2, lam) c = 
  let q_c = get_deriv c q1 
  in let q_prime = equivalence_regex q_c 
 
  
  in let listq2 = Set.toList q2 in let q_prime_equiv = handleList listq2 q_prime
  in 
  if (Set.member q_prime q2)  then (q2, (Map.insert (q1, c) q_prime lam) )--(Q, δ ∪ {(q, c) |→ q'}) 
  else if (Set.member q_prime_equiv q2) then (q2, (Map.insert (q1, c) q_prime_equiv lam) )  --(Q, δ ∪ {(q, c) |→ q'}) 
  else 
   let capital_q_prime = Set.union q2 (Set.singleton q_prime) in 
   let lambda_prime = Map.insert (q1, c) q_prime lam in 
   --just removing the explore function here 
   foldl (goto q_prime) (capital_q_prime, lambda_prime) "abc"

--take in a regex and then output a DFA 
mkDFA :: Expr -> DFAExpr
mkDFA r = 
--using '!' for the empty string char
 let q_zero = equivalence_regex (get_deriv '!' r) in 
 -- replacing the explore function
 --Map.Map (Expr, Char) (Expr)
 let (big_Q, this_lambda) = foldl (goto q_zero) ((Set.singleton q_zero), Map.empty) "abc" in 
 --iterate over the set list and take a union with the condition
 let curly_capital_F = foldl (\ (setsofar) (val) -> if (simplify_regex (v_r val)) == Empty_String then (Set.insert val setsofar) else setsofar) Set.empty (Set.toList big_Q) --{q | q in Q and simplify_regex ν_r(q) = ε} 
 in DFABuilder big_Q q_zero curly_capital_F this_lambda "abc"
 --Q Q_0 F_0 Lambda Epsilon

 


--note to self maybe the foldl are not properly working like maybe the order was swapped
--its clearly doing something right now because it recognized the empty string 
--but every other thing was just reject 
-- on the test case 
--ghci> val = parses "&(|(|(*a)(b))(!))(¬(^))"
--ghci> val
--so maybe a foldl needs its anonymous function arguments swapped 



-- https://www.haskellforall.com/2020/11/pretty-print-syntax-trees-with-this-one.html
--showReg, showApp, showVar :: Expr -> String

showDFA :: DFAExpr -> String

showDFA (DFABuilder q1 e f l epsi) = 
 "States: " ++ foldl (\ (accum) (e1) -> accum ++ show e1 ++ ",") "" (Set.toList q1) ++ "\n" 
 ++ "Start State: " ++ show e ++ "\n" 
 ++ "Accept States: " ++ foldl (\ (accum) (e3) -> accum ++ show e3 ++ ",") "" (Set.toList f) ++ "\n"
 ++ "Transition Function: \n" ++ foldl (\ (accum) ((e4, c), e5) -> accum ++ "(" ++ show e4 ++ "," ++ [c] ++ ")," ++ show e5 ++ ")\n"  ) "" (Map.toList l) ++ "\n"
 ++ "Alphabet: " ++ epsi ++ "\n"

--showApp (App e1 e2) = showApp e1 ++ " " ++ showVar e2
--showApp e = showVar e

--showVar (Var i) = i
--showVar e = "(" ++ showDFA e ++ ")"

instance Show DFAExpr where
  show e = showDFA e


