# Lambda Calculus Expressions

## Building

Use the Haskell Tool Stack [https://www.haskellstack.org]

`stack build`

## Testing

```
[None]
```

## Use

```
stack ghci
ghci> parses "| (a b) (b c)"
(a concated b)|(b concated c)
ghci> parses "&(|(|(*a)(b))(!))(¬(^))"
((((a)*)|(b))|(Empty String))&(complement (Empty Set))
ghci> test = parses "&(|(|(*a)(b))(!))(¬(^))"
ghci> check_is_string_language "" test
True
ghci> check_is_string_language "a" test
True
ghci> check_is_string_language "ab" test
False
ghci> check_is_string_language_print_steps "aa" test
["((((a)*)|(b))|(Empty String))&(complement (Empty Set))","(((Empty String concated (a)*)|(Empty Set))|(Empty Set))&(complement (Empty Set))","((((Empty Set concated (a)*)|(Empty String concated Empty String concated (a)*))|(Empty Set))|(Empty Set))&(complement (Empty Set))"]
ghci> check_against_library "aa" "*a" "a*"
True
ghci> check_against_library "aa" "b" "b"
True
ghci> mkDFA test
States: Empty String,Empty Set,(a)*,((a)*)|((b)|(Empty String)),
Start State: ((a)*)|((b)|(Empty String))
Accept States: Empty String,(a)*,((a)*)|((b)|(Empty String)),
Transition Function:
(Empty String,a),Empty Set)
(Empty String,b),Empty Set)
(Empty String,c),Empty Set)
(Empty Set,a),Empty Set)
(Empty Set,b),Empty Set)
(Empty Set,c),Empty Set)
((a)*,a),(a)*)
((a)*,b),Empty Set)
((a)*,c),Empty Set)
(((a)*)|((b)|(Empty String)),a),(a)*)
(((a)*)|((b)|(Empty String)),b),Empty String)
(((a)*)|((b)|(Empty String)),c),Empty Set)

Alphabet: abc

ghci> test_dfa = mkDFA test
ghci> is_string_dfa_accepted test_dfa ""
True
ghci> is_string_dfa_accepted test_dfa "aaaa"
True
ghci> is_string_dfa_accepted test_dfa "aaab"
False
ghci> is_string_dfa_accepted test_dfa "b"
True
ghci> is_string_dfa_accepted_print_steps "aaa" test_dfa
"((a)*)|((b)|(Empty String))"
"(a)*"
"(a)*"
"(a)*"
"Accepted"
ghci> is_string_dfa_accepted_print_steps "aab" test_dfa
"((a)*)|((b)|(Empty String))"
"(a)*"
"(a)*"
"Empty Set"
"Rejected"
ghci> string_to_dfa "a b"
States: Empty String,Empty Set,b,a concated b,
Start State: a concated b
Accept States: Empty String,
Transition Function:
(Empty String,a),Empty Set)
(Empty String,b),Empty Set)
(Empty String,c),Empty Set)
(Empty Set,a),Empty Set)
(Empty Set,b),Empty Set)
(Empty Set,c),Empty Set)
(b,a),Empty Set)
(b,b),Empty String)
(b,c),Empty Set)
(a concated b,a),b)
(a concated b,b),Empty Set)
(a concated b,c),Empty Set)

Alphabet: abc

ghci> test2 = string_to_dfa "a b"
```

# Syntax

```
use prefix notation for everything and preferably parens, each char needs to be seperated by a space from another char besides parens and prefix notations
use ! for empty string and ^ for empty set and ¬ for complement/negation
it might fail if you try to match with + or some other symbol
just because it passed the parser does not necessarily mean that it is ready to go
the external library that tests against for the regex has a mistake and occasionally outputs the wrong answer as it seems to try to find any match instead of matching the entire string
```
The alphabet for simplicity and demo purposes and speed is set up to only be the letters "abc" right now.
If you try to use things outside the library for checking the behavior is undefined, it does an pretty good job usually since its mostly false anyway.
If you want to extend the alphabet you need to swap out all the "abc" in DFAAST.hs for your alphabet without using any of the already taken symbols and also without taking '/'


The check_against_library is not working well because the other library is not that great.
```
ghci> import Text.Regex.TDFA
ghci> "foo|b" =~ "(foo|bar)" :: Bool
True
```
Versus the version with the Derivatives that does not use an alphabet:
```
ghci> testval = parses "|(f o o)(b a r)"
ghci> check_is_string_language "foo|b" testval
False
```

Only around half the files here are related to the project the rest are from my implementation of HW2 
The main.hs is set up to be a command line tool with stack run to let people play around with the parsing in prefix notation


The project uses Brzowski derivatives to evaluate the regex and compute the dfa and then runs the dfa to test if it is working in other functions.
You don't need to convert to DFA to evaluate the string which is why there are multiple implementations of it being evaluated. 
Do not deploy this code as the checking for regex equivalence is NOT optimized. 
