-- module Main where

-- main :: IO ()
-- main = putStrLn "Hello, Haskell!"

module Main where

import Terrain
import Numeric.Noise.Perlin
import Codec.Picture
import Biome
import Criterion.Main
import Control.Monad (replicateM_, forM_)
import System.Random

-- Define width and height as constants
width :: Int
width = 800 * 20000

height :: Int
height = 600 * 20000

main :: IO ()
main = do
    bm
    other

bm :: IO ()
bm = defaultMain [
    bgroup "Terrain Generation" [ bench "Sequential" $ nfIO generateTerrainSeq,
                                  bench "Parallel" $ nfIO generateTerrainPar],
    bgroup "Voronoi Biome Generation" [ bench "Sequential" $ nfIO generateBiomeSeq,
                                        bench "Parallel" $ nfIO generateBiomePar]
  ]

generateTerrainSeq :: IO ()
generateTerrainSeq = do
  let noise = perlin 4 5 0.005 0.05
  replicateM_ 100 $ do
    let noiseData = generateSmoothNoiseSeq width height 100 noise
    let image = renderHeatMap width height noiseData
    -- writePng "terrain_seq.png" image
    return ()

generateTerrainPar :: IO ()
generateTerrainPar = do
  gen <- newStdGen
  let seeds = take 100 (randoms gen :: [Int])
  forM_ seeds $ \seed -> do
    let noise = perlin seed 5 0.005 0.05
    let noiseData = generateSmoothNoise width height 100 noise
    let image = renderHeatMap width height noiseData
    -- writePng "terrain_par.png" image
    return ()

generateBiomeSeq :: IO ()
generateBiomeSeq = do
  let numSeeds = 1000 
  replicateM_ 100 $ do
    seeds <- generateSeeds numSeeds width height
    let imageVoronoi = renderVoronoiSeq width height seeds
    -- writePng "voronoi_seq.png" imageVoronoi
    return ()

generateBiomePar :: IO ()
generateBiomePar = do
  let numSeeds = 1000 
  replicateM_ 100 $ do
    seeds <- generateSeeds numSeeds width height
    let imageVoronoi = renderVoronoiPar width height seeds
    -- writePng "voronoi_par.png" imageVoronoi
    return ()



other :: IO ()
other = do
  let width = 800
  let height = 600
  -- First part: generating and saving the terrain image
  let noise = perlin 4 5 0.005 0.05
      noiseData = generateNoise width height noise
      image = renderHeatMap width height noiseData
  writePng "terrain.png" image

  -- Second part: generating and saving the Voronoi biomes image
  let numSeeds = 10000 
  seeds <- generateSeeds numSeeds width height
  let imageVoronoi = renderVoronoiSeq width height seeds
  writePng "voronoi_biomes.png" imageVoronoi
