# Parallelized Procedural Terrain Generation

This project plans to deal with procedural terrain generation. In the realm of computer graphics and algorithmic design, the creation of realistic and varied digital landscapes is a captivating challenge. Taking on this problem, I aim to develop a system capable of generating large-scale, complex terrains through procedural algorithms, leveraging the power of parallel computing. At its core, the problem involves generating random numbers, taking their dot products, smoothing them out, and then combining this with some sort of heatmap rendering function (thresholding, further smoothing via kernel convolution, etc). What really constitutes a better terrain is sort of “subjective” but different methods yield unique results. At a glance, my project stands at the intersection of art and technology--combining aesthetics with advanced computational techniques.

### Setting Up

These are commands for setting up this project. Ensure you have Haskell installed on your system and then run these commands to build the cabal project `terrain-generation`
```
cabal clean
cabal configure --enable-profiling
cabal build
```

### Running with Profiling:
```
cabal run terrain-generation -- +RTS -p -N6 -RTS
```
replace the _ in "+N_" above with the number of cores you want to run this program on. The max will depend on your host machine. I ran it with 6 cores.

