{-# language ViewPatterns #-}
-- Sequential implementation adapted from https://www.47deg.com/blog/game-of-life-haskell/

module Main where

import qualified Data.ByteString.Char8 as B
import Logic
import Control.Monad.Par
import System.Environment

wIDTH :: Integer
wIDTH = 1000

hEIGHT :: Integer
hEIGHT = 1000

sTEP :: Integer
sTEP = 1

main :: IO ()
main = do
  [file] <- getArgs
  initialGrid <- parseInitialGrid <$> B.readFile file
  printSetup sTEP wIDTH hEIGHT
  putStrLn "finished parsing"
  let f = gameOfLife initialGrid
      calcCellAndShow point = showCell' (f sTEP point)
      calcRow row = runPar (parMap calcCellAndShow [(y, row) | y <- [0..(wIDTH-1)]])
  mapM_ putStrLn [calcRow x | x <- [0..(hEIGHT-1)]]
  putStrLn "done"
  printSetup sTEP wIDTH hEIGHT

parseInitialGrid :: B.ByteString -> Grid
parseInitialGrid s = go
  where
    ls = B.split '\n' s
    maxY = fromInteger wIDTH
    maxX = fromInteger hEIGHT
    go (fromInteger -> y, fromInteger -> x)
      | x < 0                         = Dead
      | y < 0                         = Dead
      | x >= maxX                     = Dead
      | y >= maxY                     = Dead
      | y >= (B.length (ls !! x) - 1) = Dead
      | B.index (ls !! x) y == '.'    = Dead
      | otherwise                     = Alive

printSetup :: (Show a1, Show a2, Show a3) => a1 -> a2 -> a3 -> IO ()
printSetup step width height = putStrLn (show step ++ " " ++ show width ++ "x" ++ show height)