module Logic where

-- | A point in the grid
type Point = (Integer, Integer)
-- | The status of a cell
data Cell = Alive | Dead deriving Eq
-- | Description of a grid
type Grid = Point -> Cell

showCell' :: Cell -> Char
showCell' Alive = 'X'
showCell' Dead = '.'

nextStep :: Cell -> [Cell] -> Cell
nextStep Alive adj
  | count Alive adj < 2 = Dead  -- underpopulation
  | count Alive adj > 3 = Dead  -- overpopulation
  | otherwise           = Alive  -- Alive and let Alive
nextStep Dead adj
  | count Alive adj == 3 = Alive  -- reproduction
  | otherwise            = Dead  -- nothing happens
  

gameOfLife :: Grid -> Integer -> Grid
gameOfLife initial 0 p
  = initial p
gameOfLife initial n p
  = nextStep (gameOfLife initial (n-1) p)
             (map (gameOfLife initial (n-1)) (adjacents p))

adjacents :: Point -> [Point]
adjacents (x,y)
  = [(x+m, y+n) | m <- [-1,0,1], n <- [-1,0,1], (m,n) /= (0,0)]

count :: Eq a => a -> [a] -> Int
count x = length . filter (== x)
