#include "vga_ball.h"
#include <fcntl.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

int vga_ball_fd;

int read_background_color(vga_ball_arg_t *vla) {
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, vla)) {
    perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
    return -1;
  }
  return 0;
}

/* Read and print the background color */
void print_background_color() {
  vga_ball_arg_t vla;

  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
    perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
    return;
  }
  printf("%02x %02x %02x\n", vla.background.red, vla.background.green,
         vla.background.blue);
}

/* Set the background color */
char set_background_color(const vga_ball_color_t *c) {
  vga_ball_arg_t vla, temp;
  vla.background = *c;
  char t = 1;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
    perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
    return t;
  }

  while (t == 1) {
     //printf("%d \n",vla.image[0]);
    if (ioctl(vga_ball_fd, VGA_BALL_READ_VALUE, &temp)) {
      perror("ioctl(VGA_BALL_READ_VALUE) failed");
      return t;
    }
    t = temp.image[0];
    //printf("t=%d\n",t);
    usleep(100000);
  }
  return t;
}

/* Set the value */
void set_value(vga_ball_value_t *v) {
  vga_ball_arg_t vla;
  vla.value = *v;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_VALUE, &vla)) {
    perror("ioctl(VGA_BALL_WRITE_VALUE) failed");
    return;
  }
}

/* Clear BRAM memory */
void clear_bram(vga_ball_value_t *v) {
  vga_ball_arg_t vla;
  vla.value = *v;
  if (ioctl(vga_ball_fd, VGA_BALL_MEM_CLEAR, &vla)) {
    perror("ioctl(VGA_BALL_MEM_CLEAR) failed");
    return;
  }
}

/* Read and print the value from hardware */
void read_value(char *image_data, int start_index) {
  vga_ball_arg_t vla;

  // vla.value.addr = address;
  if (ioctl(vga_ball_fd, VGA_BALL_READ_VALUE, &vla)) {
    perror("ioctl(VGA_BALL_READ_VALUE) failed");
    return;
  }
  // usleep(200000);
  // printf("value at address %u is %u\n",address, vla.value.val);
  for (int i = 0; i < BUFFER_IMAGE_SIZE; i++) {
    // printf("%d \n",vla.image[0]);
    image_data[start_index] = vla.image[i];
  }
}
