#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>
#define IMAGE_HEIGHT 350
#define IMAGE_WIDTH 525
# define IMAGE_SIZE IMAGE_HEIGHT * IMAGE_WIDTH
# define BUFFER_IMAGE_SIZE 1
//# define NUM_IOCTL_READS 10000
# define NUM_IOCTL_READS IMAGE_SIZE/BUFFER_IMAGE_SIZE
typedef struct {
	char red, green, blue;
} vga_ball_color_t;

typedef struct {
	char x, y;
} vga_ball_pos_t;

typedef struct {
	char val;
        unsigned int addr;
} vga_ball_value_t;

typedef struct {
  vga_ball_color_t background;
  //vga_ball_pos_t position;
  vga_ball_value_t value;
  char image[BUFFER_IMAGE_SIZE];
} vga_ball_arg_t;


#define VGA_BALL_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_BALL_WRITE_BACKGROUND _IOW(VGA_BALL_MAGIC, 1, vga_ball_arg_t *)
#define VGA_BALL_READ_BACKGROUND  _IOR(VGA_BALL_MAGIC, 2, vga_ball_arg_t *)
//#define VGA_BALL_WRITE_POSITION   _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg_t *)
#define VGA_BALL_WRITE_VALUE      _IOW(VGA_BALL_MAGIC, 3, vga_ball_arg_t *)
#define VGA_BALL_READ_VALUE       _IOR(VGA_BALL_MAGIC, 4, vga_ball_arg_t *)
#define VGA_BALL_MEM_CLEAR        _IOR(VGA_BALL_MAGIC, 5, vga_ball_arg_t *)

#endif
